<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="<?php echo e($alert_col); ?>">
        <div class="card">
            <div class="card-header">
                <span class="panel-title"><i class="fas fa-lock"></i> <?php echo e(_lang('Employee Login Access')); ?></span>
            </div>
            <div class="card-body">
                <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('employees.login_access', $id)); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Name')); ?></label>
                                <div class="col-xl-9">
                                    <input type="text" class="form-control" name="name" value="<?php echo e(old('name', $employee->user->name)); ?>"
                                        required>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Email')); ?></label>
                                <div class="col-xl-9">
                                    <input type="email" class="form-control" name="email" value="<?php echo e(old('email', $employee->user->email)); ?>"
                                        required>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Password')); ?></label>
                                <div class="col-xl-9">
                                    <input type="password" class="form-control" name="password" <?php echo e($employee->user->password == null ? 'required' : ''); ?>>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Status')); ?></label>
                                <div class="col-xl-9">
                                    <select class="form-control auto-select" data-selected="<?php echo e($employee->user->status ?? old('status', 1)); ?>"
                                        name="status" required>
                                        <option value=""><?php echo e(_lang('Select One')); ?></option>
                                        <option value="1"><?php echo e(_lang('Active')); ?></option>
                                        <option value="0"><?php echo e(_lang('In Active')); ?></option>
                                    </select>
                                    <a href="" class="mt-3 d-block toggle-optional-fields" data-toggle-title="<?php echo e(_lang('Hide Optional Fields')); ?>"><?php echo e(_lang('Show Optional Fields')); ?></a>
                                </div>
                            </div>
   
                            <div class="form-group row optional-field">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Phone')); ?></label>
                                <div class="col-xl-9">
                                    <input type="text" class="form-control" name="phone" value="<?php echo e(old('phone', $employee->user->phone)); ?>">
                                </div>
                            </div>

                            <div class="form-group row optional-field">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('City')); ?></label>
                                <div class="col-xl-9">
                                    <input type="text" class="form-control" name="city" value="<?php echo e(old('city', $employee->user->city)); ?>">
                                </div>
                            </div>

                            <div class="form-group row optional-field">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('State')); ?></label>
                                <div class="col-xl-9">
                                    <input type="text" class="form-control" name="state" value="<?php echo e(old('state', $employee->user->state)); ?>">
                                </div>
                            </div>

                            <div class="form-group row optional-field">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('ZIP')); ?></label>
                                <div class="col-xl-9">
                                    <input type="text" class="form-control" name="zip" value="<?php echo e(old('zip', $employee->user->zip)); ?>">
                                </div>
                            </div>

                            <div class="form-group row optional-field">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Address')); ?></label>
                                <div class="col-xl-9">
                                    <textarea class="form-control" name="address"><?php echo e(old('address', $employee->user->address)); ?></textarea>
                                </div>
                            </div>

                            <div class="form-group row optional-field">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Profile Picture')); ?></label>
                                <div class="col-xl-9">
                                    <input type="file" class="dropify" name="profile_picture" data-default-file="<?php echo e($employee->user->profile_picture != null ? asset('public/uploads/media/'.$employee->user->profile_picture) : ''); ?>">
                                </div>
                            </div>
    
                            <div class="form-group row mt-4">
                                <div class="col-xl-9 offset-xl-3">
                                    <button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i><?php echo e(_lang('Save Changes')); ?></button>
                                </div>
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/employee/login_access.blade.php ENDPATH**/ ?>