<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-10 offset-lg-1">
		<div class="card">
			<div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Attendance Report')); ?></span>
				<button class="btn btn-outline-primary btn-xs print" data-print="report" type="button" id="report-print-btn"><i class="fas fa-print mr-1"></i><?php echo e(_lang('Print Report')); ?></button>
			</div>

			<div class="card-body">

				<div class="report-params">
					<form class="validate" method="GET" action="<?php echo e(route('reports.attendance_report')); ?>" autocomplete="off">
						<div class="row">
							<div class="col-xl-3 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Month')); ?></label>						
									<select type="text" class="form-control auto-select" name="month" data-selected="<?php echo e(isset($month) ? $month : old('month', date('m'))); ?>" required>
										<?php for($m = 1; $m <=12; $m++): ?>
										<option value="<?php echo e(date('m', mktime(0, 0, 0, $m, 10))); ?>"><?php echo e(date('F', mktime(0, 0, 0, $m, 10))); ?></option>
										<?php endfor; ?>
									</select>
								</div>
							</div>

							<div class="col-xl-3 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Year')); ?></label>						
									<select type="text" class="form-control auto-select" name="year" data-selected="<?php echo e(isset($year) ? $year : old('year', date('Y'))); ?>" required>
										<?php for($y = 2020; $y <=date('Y'); $y++): ?>
										<option value="<?php echo e($y); ?>"><?php echo e($y); ?></option>
										<?php endfor; ?>
									</select>
								</div>
							</div>

							<div class="col-xl-2 col-lg-4">
								<button type="submit" class="btn btn-light btn-xs btn-block mt-26"><i class="ti-filter mr-1"></i><?php echo e(_lang('Filter')); ?></button>
							</div>
						</form>

					</div>
				</div><!--End Report param-->

				<?php $date_format = get_date_format(); ?>

				<div id="report">
					<div class="report-header">
						<h4><?php echo e(get_tenant_option('business_name', request()->tenant->name)); ?></h4>
						<p><?php echo e(_lang('Attendance Report')); ?></p>
						<p><?php echo e(isset($month) && isset($year) ? date('F', mktime(0, 0, 0, $month, 10)) .', '. $year : ''); ?></p>
					</div>

					<?php if(isset($report_data)): ?>
					<div class="table-responsive">
						<table class="payslip-table w-100" border="1">
							<thead class="bg-light">
								<th><?php echo e(_lang('Employee ID')); ?></th>
								<th><?php echo e(_lang('Name')); ?></th>
								<?php for($day = 1; $day <= $calendar; $day++): ?>
								<th><?php echo e($day); ?></th>
								<?php endfor; ?>
							</thead>
							<tbody>
								<?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($employee->employee_id); ?></td>
										<td><?php echo e($employee->name); ?></td>
										<?php for($day = 1; $day <= $calendar; $day++): ?>
											<?php if(isset($report_data[$employee->id])): ?>
											<td><?php echo e(isset($report_data[$employee->id][$day]) ? $report_data[$employee->id][$day] : ''); ?></td>
											<?php else: ?>
											<td></td>
											<?php endif; ?>
										<?php endfor; ?>				
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>

					<!--Legend-->
					<div class="row">
						<div class="col-md-6">
							<table class="payslip-table mt-4" border="1">
								<thead class="bg-light">
									<th>A</th>
									<th>P</th>
									<th>L</th>
									<th>W</th>
									<th>H</th>
								</thead>
								<tbody>
									<tr>
										<td><?php echo e(_lang('Absent')); ?></td>
										<td><?php echo e(_lang('Present')); ?></td>
										<td><?php echo e(_lang('Leave')); ?></td>
										<td><?php echo e(_lang('Weekend')); ?></td>
										<td><?php echo e(_lang('Holiday')); ?></td>
									</tr>
								</thead>
							</table>
						</div>
						<div class="col-md-6">
							<table class="payslip-table mt-4 float-md-right" border="1">
								<thead class="bg-light">
									<th><?php echo e(_lang('Working Days')); ?></th>
								</thead>
								<tbody>
									<tr>
										<td class="text-center"><?php echo e($attendance_list->groupBy('date')->count()); ?></td>
									</tr>
								</thead>
							</table>
						</div>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/reports/attendance_report.blade.php ENDPATH**/ ?>