<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Designations')); ?></span>
				<div>
					<a class="btn btn-danger btn-xs" href="<?php echo e(route('departments.index')); ?>"><i class="fas fa-list-ul"></i> <?php echo e(_lang('Departments')); ?></a>
					<a class="btn btn-primary btn-xs ajax-modal" data-title="<?php echo e(_lang('Add Designation')); ?>" href="<?php echo e(route('designations.create')); ?>"><i class="ti-plus"></i> <?php echo e(_lang('Add New')); ?></a>
				</div>
			</div>
			<div class="card-body">
				<table id="designations_table" class="table data-table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Designation')); ?></th>
							<th><?php echo e(_lang('Department')); ?></th>
							<th><?php echo e(_lang('Descriptions')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					    <?php $__currentLoopData = $designations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $designation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					    <tr data-id="row_<?php echo e($designation->id); ?>">
							<td class='name'><?php echo e($designation->name); ?></td>
							<td class='department_id'><?php echo e($designation->department->name); ?></td>
							<td class='descriptions'><?php echo e($designation->descriptions); ?></td>
							
							<td class="text-center">
								<span class="dropdown">
								  <button class="btn btn-outline-primary dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								  <?php echo e(_lang('Action')); ?>

								  </button>
								  <form action="<?php echo e(route('designations.destroy', $designation['id'])); ?>" method="post">
									<?php echo e(csrf_field()); ?>

									<input name="_method" type="hidden" value="DELETE">

									<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="<?php echo e(route('designations.edit', $designation['id'])); ?>" data-title="<?php echo e(_lang('Update Designation')); ?>" class="dropdown-item dropdown-edit ajax-modal"><i class="fas fa-pencil-alt"></i> <?php echo e(_lang('Edit')); ?></a>
										<button class="btn-remove dropdown-item" type="submit"><i class="fas fa-trash-alt"></i> <?php echo e(_lang('Delete')); ?></button>
									</div>
								  </form>
								</span>
							</td>
					    </tr>
					    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/designation/list.blade.php ENDPATH**/ ?>