<form method="post" class="ajax-submit" autocomplete="off" action="<?php echo e(route('employee_expenses.store')); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <div class="row p-2">
        <div class="col-lg-6">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Trans Date')); ?></label>						
                <input type="text" class="form-control datetimepicker" name="trans_date" value="<?php echo e(old('trans_date', now())); ?>" required>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Employee')); ?></label>						
                <select class="form-control auto-select select2" data-selected="<?php echo e(old('employee_id')); ?>" name="employee_id" required>
                    <option value=""><?php echo e(_lang('Select One')); ?></option>
                    <?php $__currentLoopData = \App\Models\Employee::active()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($employee->id); ?>"><?php echo e($employee->employee_id); ?> (<?php echo e($employee->name); ?>)</option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Bill No')); ?></label>						
                <input type="text" class="form-control" name="bill_no" value="<?php echo e(old('bill_no')); ?>">
            </div>
        </div>


        <div class="col-lg-6">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Amount')); ?></label>						
                <input type="text" class="form-control float-field" name="amount" value="<?php echo e(old('amount')); ?>" required>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Category')); ?></label>						
                <select class="form-control select2-ajax" name="expense_category_id" data-table="employee_expense_categories"
                data-value="id" data-display="name" data-where="3" data-title="<?php echo e(_lang('Add Category')); ?>" data-href="<?php echo e(route('employee_expense_categories.create')); ?>" required>
                <option value=""><?php echo e(_lang('Select One')); ?></option>
                </select>
            </div>
        </div>

        <div class="col-lg-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Status')); ?></label>						
				<select class="form-control auto-select" data-selected="<?php echo e(old('status', 1)); ?>" name="status"  required>
					<option value="1"><?php echo e(_lang('Completed')); ?></option>
					<option value="0"><?php echo e(_lang('Pending')); ?></option>
				</select>
			</div>
		</div>

        <div class="col-lg-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Description')); ?></label>						
                <textarea class="form-control" name="description"><?php echo e(old('description')); ?></textarea>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Attachment')); ?></label>						
                <input type="file" class="dropify" name="attachment" >
            </div>
        </div>

        <div class="col-lg-12 mt-2">
            <div class="form-group">
                <button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Submit')); ?></button>
            </div>
        </div>
    </div>
</form><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/employee_expense/modal/create.blade.php ENDPATH**/ ?>