<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card no-export">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title"><?php echo e(_lang('Employee Documents')); ?></span>
				<a class="btn btn-primary btn-xs ml-auto ajax-modal" data-title="<?php echo e(_lang('Add New Document')); ?>" href="<?php echo e(route('employee_documents.create', $id)); ?>"><i class="ti-plus mr-2"></i><?php echo e(_lang('Add New')); ?></a>
			</div>
			<div class="card-body">
				<table id="staff_documents_table" class="table data-table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Employee ID')); ?></th>
						    <th><?php echo e(_lang('Name')); ?></th>
							<th><?php echo e(_lang('Document Name')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					    <?php $__currentLoopData = $staffDocuments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staffDocument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					    <tr data-id="row_<?php echo e($staffDocument->id); ?>">
							<td class='staff_id'><?php echo e($staffDocument->staff->employee_id); ?></td>
							<td class='staff_name'><?php echo e($staffDocument->staff->first_name.' '.$staffDocument->staff->last_name); ?></td>
							<td class='name'><?php echo e($staffDocument->name); ?></td>
							
							<td class="text-center">
								<span class="dropdown">
								  <button class="btn btn-outline-primary dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								  <?php echo e(_lang('Action')); ?>

								  </button>
								  <form action="<?php echo e(route('employee_documents.destroy', $staffDocument['id'])); ?>" method="post">
									<?php echo e(csrf_field()); ?>

									<input name="_method" type="hidden" value="DELETE">

									<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="<?php echo e(asset('storage/app/public/'. $staffDocument->document)); ?>" class="dropdown-item" target="_blank"><i class="fas fa-eye mr-1"></i><?php echo e(_lang('View')); ?></a>
										<a href="<?php echo e(route('employee_documents.edit', $staffDocument['id'])); ?>" data-title="<?php echo e(_lang('Update Document')); ?>" class="dropdown-item dropdown-edit ajax-modal"><i class="far fa-edit mr-1"></i><?php echo e(_lang('Edit')); ?></a>
										<button class="btn-remove dropdown-item" type="submit"><i class="fas fa-trash-alt mr-1"></i><?php echo e(_lang('Delete')); ?></button>
									</div>
								  </form>
								</span>
							</td>
					    </tr>
					    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/employee_documents/list.blade.php ENDPATH**/ ?>