<div class="card">
    <div class="card-header text-center">
        <span class="panel-title"><?php echo e(_lang('Payroll Details')); ?></span>
    </div>
    
    <div class="card-body">
        <div class="row mb-4">
            <div class="col-lg-6">        
                <h5 class="mb-2"><?php echo e(_lang('Benefits Overview')); ?></h5>
                <table class="payslip-table w-100" border="1">
                    <thead class="bg-light">
                        <th><?php echo e(_lang('Name')); ?></th>
                        <th class="text-right"><?php echo e(_lang('Amount')); ?></th>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $benefits_deductions->where('type', 'add'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $benefit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($benefit->name); ?></td>
                            <td class="text-right"><?php echo e(decimalPlace($benefit->amount, currency_symbol())); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="col-lg-6">
                <h5 class="mb-2"><?php echo e(_lang('Deductions Overview')); ?></h5>
                <table class="payslip-table w-100" border="1">
                    <thead class="bg-light">
                        <th><?php echo e(_lang('Name')); ?></th>
                        <th class="text-right"><?php echo e(_lang('Amount')); ?></th>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $benefits_deductions->where('type', 'deduct'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deduction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($deduction->name); ?></td>
                            <td class="text-right"><?php echo e(decimalPlace($deduction->amount, currency_symbol())); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="table-responsive">
            <table id="payslips_table" class="table table-bordered">
                <thead>
                    <tr>
                        <th><?php echo e(_lang('Employee ID')); ?></th>
                        <th><?php echo e(_lang('Name')); ?></th>
                        <th><?php echo e(_lang('Year')); ?></th>
                        <th><?php echo e(_lang('Month')); ?></th>
                        <th class="text-right"><?php echo e(_lang('Net Salary')); ?></th>
                        <th class="text-center"><?php echo e(_lang('Status')); ?></th>
                        <th class="text-center"><?php echo e(_lang('Action')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $payrolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payroll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($employee->employee_id); ?></td>
                        <td><?php echo e($employee->name); ?></td>
                        <td><?php echo e($payroll->year); ?></td>
                        <td><?php echo e(date('F', mktime(0, 0, 0, $payroll->month, 10))); ?></td>
                        <td class="text-right"><?php echo e(decimalPlace($payroll->net_salary, currency_symbol())); ?></td>
                        <td class="text-center"><?php echo xss_clean(payroll_status($payroll->status)); ?></td>
                        <td class="text-center">
                            <?php if($payroll->status == 0): ?>
                                <div class="dropdown text-center">
                                    <button class="btn btn-outline-primary btn-xs dropdown-toggle" type="button" data-toggle="dropdown"><?php echo e(_lang('Action')); ?></button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo e(route('payslips.edit', $payroll['id'])); ?>"><i class="fas fa-pencil-alt mr-1"></i><?php echo e(_lang('Edit')); ?></a>
                                        <a class="dropdown-item" href="<?php echo e(route('payslips.show', $payroll['id'])); ?>"><i class="fas fa-eye mr-1"></i> <?php echo e(_lang('Details')); ?></a>
                                        <form action="<?php echo e(route('payslips.destroy', $payroll['id'])); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <input name="_method" type="hidden" value="DELETE">
                                            <button class="dropdown-item btn-remove" type="submit"><i class="fas fa-trash-alt mr-1"></i> <?php echo e(_lang('Delete')); ?></button>
                                        </form>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="dropdown text-center">
                                    <button class="btn btn-outline-primary btn-xs dropdown-toggle" type="button" data-toggle="dropdown"><?php echo e(_lang('Action')); ?></button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo e(route('payslips.show', $payroll['id'])); ?>"><i class="fas fa-eye mr-1"></i> <?php echo e(_lang('Details')); ?></a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="float-right">
            <?php echo e($payrolls->links()); ?>

        </div>
    </div>
</div><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/employee/tabs/payroll.blade.php ENDPATH**/ ?>