<?php $__env->startSection('content'); ?>
<form method="post" class="validate" autocomplete="off" action="<?php echo e(route('payslips.update', $id)); ?>" enctype="multipart/form-data">
	<?php echo csrf_field(); ?>
	<input name="_method" type="hidden" value="PATCH">
	<div class="row">
		<div class="<?php echo e($alert_col); ?>">
			<div class="card">
				<div class="card-header d-flex align-items-center justify-content-between">
					<span class="panel-title"><?php echo e(_lang('Update Payslip')); ?></span>
					<?php echo xss_clean(payroll_status($payroll->status)); ?>

				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Employee ID')); ?></label>						
								<input type="text" class="form-control" name="employee_id" value="<?php echo e($payroll->staff->employee_id); ?>" disabled>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Employee Name')); ?></label>						
								<input type="text" class="form-control" name="employee_id" value="<?php echo e($payroll->staff->name); ?>" disabled>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Month')); ?></label>						
								<input type="text" class="form-control" name="month" value="<?php echo e(date('F', mktime(0, 0, 0, $payroll->month, 10))); ?>" disabled>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Year')); ?></label>						
								<input type="text" class="form-control" name="year" value="<?php echo e($payroll->year); ?>" disabled>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Basic Salary')); ?></label>						
								<input type="text" class="form-control" name="current_salary" id="basic_salary" value="<?php echo e($payroll->current_salary); ?>" disabled>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Expense Claim')); ?></label>						
								<input type="text" class="form-control" name="expense" id="expense" value="<?php echo e($payroll->expense); ?>" disabled>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Absence Fine')); ?></label>						
								<input type="text" class="form-control" name="absence_fine" id="absence_fine" value="<?php echo e($payroll->absence_fine); ?>" disabled>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Loan')); ?></label>						
								<input type="text" class="form-control" name="loan" id="loan" value="<?php echo e($payroll->loan); ?>" disabled>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Loan Interest')); ?></label>						
								<input type="text" class="form-control" name="loan_interest" id="loan_interest" value="<?php echo e($payroll->loan_interest); ?>" disabled>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Net Salary')); ?> (<?php echo e(currency_symbol()); ?>)</label>						
								<input type="text" class="form-control" id="net_salary" name="net_salary" value="<?php echo e($payroll->net_salary); ?>" disabled>
							</div>
						</div>

						<div class="col-lg-6 mt-4">
							<div class="card">
								<div class="card-header d-flex justify-content-between">
									<span class="panel-title text-success font-weight-bold"><?php echo e(_lang('Allowances')); ?></span>
									<button type="button" class="btn btn-outline-success btn-xs" id="add-allowances"><i class="fas fa-plus"></i></button>
								</div>
								<div class="card-body">
									<table class="table table-bordered" id="allowances">
										<thead class="bg-white">
											<th class="text-dark"><?php echo e(_lang('Name')); ?></th>
											<th class="text-dark"><?php echo e(_lang('Amount')); ?></th>
											<th class="text-dark"><?php echo e(_lang('Amount Type')); ?></th>
											<th class="text-dark text-center"><?php echo e(_lang('Action')); ?></th>
										</thead>
										<tbody>
											<?php $__currentLoopData = $payroll->payroll_benefits()->where('type','add')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowances): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td>
													<input type="hidden" name="allowances[payslip_id][]" value="<?php echo e($allowances->id); ?>">
													<input type="text" class="form-control" name="allowances[name][]" placeholder="<?php echo e(_lang('Name')); ?>" value="<?php echo e($allowances->name); ?>" required>
												</td>
												<td><input type="text" class="form-control float-amount add_amount" name="allowances[amount][]" placeholder="<?php echo e(_lang('Amount')); ?>" value="<?php echo e($allowances->amount); ?>" required></td>
												<td>
													<select class="form-control auto-select amount_type" data-selected="<?php echo e($allowances->amount_type); ?>" name="allowances[amount_type][]" required>
														<option value="fixed"><?php echo e(_lang('Fixed')); ?></option>
														<option value="percent"><?php echo e(_lang('Percent')); ?>(%)</option>
													</select>
												</td>
												<td class="text-center"><button class="btn btn-danger btn-xs remove-item"><i class="far fa-trash-alt"></i></button></td>
											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>

						<div class="col-lg-6 mt-4">
							<div class="card">
								<div class="card-header d-flex justify-content-between">
									<span class="panel-title text-danger font-weight-bold"><?php echo e(_lang('Deductions')); ?></span>
									<button type="button" class="btn btn-outline-danger btn-xs" id="add-deductions"><i class="fas fa-plus"></i></button>
								</div>
								<div class="card-body">
									<table class="table table-bordered" id="deductions">
										<thead class="bg-white">
											<th class="text-dark"><?php echo e(_lang('Name')); ?></th>
											<th class="text-dark"><?php echo e(_lang('Amount')); ?></th>
											<th class="text-dark"><?php echo e(_lang('Amount Type')); ?></th>
											<th class="text-dark text-center"><?php echo e(_lang('Action')); ?></th>
										</thead>
										<tbody>
											<?php $__currentLoopData = $payroll->payroll_benefits()->where('type','deduct')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deductions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td>
													<input type="hidden" name="deductions[payslip_id][]" value="<?php echo e($deductions->id); ?>">
													<input type="text" class="form-control" name="deductions[name][]" placeholder="<?php echo e(_lang('Name')); ?>" value="<?php echo e($deductions->name); ?>" required>
												</td>
												<td><input type="text" class="form-control float-amount deduct_amount" name="deductions[amount][]" placeholder="<?php echo e(_lang('Amount')); ?>" value="<?php echo e($deductions->amount); ?>" required></td>
												<td>
													<select class="form-control auto-select amount_type" data-selected="<?php echo e($deductions->amount_type); ?>" name="deductions[amount_type][]" required>
														<option value="fixed"><?php echo e(_lang('Fixed')); ?></option>
														<option value="percent"><?php echo e(_lang('Percent')); ?>(%)</option>
													</select>
												</td>
												<td class="text-center"><button class="btn btn-danger btn-xs remove-item"><i class="far fa-trash-alt"></i></button></td>
											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>

						<div class="col-lg-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Update')); ?></button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function($) {
    "use strict";
	$(document).on('click', '#add-allowances', function(){
		$("#allowances tbody").append(`<tr>
										<td>
											<input type="text" class="form-control" name="allowances[name][]" placeholder="<?php echo e(_lang('Name')); ?>" required>
										</td>
										<td><input type="text" class="form-control float-amount add_amount" name="allowances[amount][]" placeholder="<?php echo e(_lang('Amount')); ?>" required></td>
										<td>
											<select class="form-control amount_type" name="allowances[amount_type][]" required>
												<option value="fixed"><?php echo e(_lang('Fixed')); ?></option>
												<option value="percent"><?php echo e(_lang('Percent')); ?>(%)</option>
											</select>
										</td>
										<td class="text-center"><button class="btn btn-danger btn-xs remove-item"><i class="far fa-trash-alt"></i></button></td>
									</tr>`);
	});

	$(document).on('click', '#add-deductions', function(){
		$("#deductions tbody").append(`<tr>
										<td>
											<input type="text" class="form-control" name="deductions[name][]" placeholder="<?php echo e(_lang('Name')); ?>" required>
										</td>
										<td><input type="text" class="form-control float-amount deduct_amount" name="deductions[amount][]" placeholder="<?php echo e(_lang('Amount')); ?>" required></td>
										<td>
											<select class="form-control amount_type" name="deductions[amount_type][]" required>
												<option value="fixed"><?php echo e(_lang('Fixed')); ?></option>
												<option value="percent"><?php echo e(_lang('Percent')); ?>(%)</option>
											</select>
										</td>
										<td class="text-center"><button class="btn btn-danger btn-xs remove-item"><i class="far fa-trash-alt"></i></button></td>
									</tr>`);
	});

	$(document).on('click', '.remove-item', function(){
		$(this).parent().parent().remove();
		calculatingNetTotal();
	});

	$(document).on('change keyup blur','.add_amount,.deduct_amount', function(){
		if($(this).val() == ''){
			$(this).val(0);
		}else{
			calculatingNetTotal();
		}
	});

	function calculatingNetTotal(){
		//Calculating Total Allowance
		var total_allowance = parseFloat($('#basic_salary').val()) + parseFloat($('#expense').val());

		$("#allowances tbody > tr").each(function(index, item) {
			var basicSalary = parseFloat($('#basic_salary').val());

			if($(item).find('.amount_type').val() == 'percent'){
				total_allowance += (parseFloat($(item).find('.add_amount').val()) / 100) * basicSalary;
			}else{
				total_allowance += parseFloat($(item).find('.add_amount').val());
			}
		});

		//Calculating Total Deduction
		var total_deduction = 0;
		if(typeof($('#absence_fine').val()) != 'undefined'){
			total_deduction += parseFloat($('#absence_fine').val());
		}

		$("#deductions tbody > tr").each(function(index, item) {
			var basicSalary = parseFloat($('#basic_salary').val());

			if($(item).find('.amount_type').val() == 'percent'){
				total_deduction += (parseFloat($(item).find('.deduct_amount').val()) / 100) * basicSalary;
			}else{
				total_deduction += parseFloat($(item).find('.deduct_amount').val());
			}
		});

		//Calculating Net Salary
		var net_salary = total_allowance - total_deduction;
		$('#net_salary').val(net_salary.toFixed(2));
	}

})(jQuery);
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/payroll/edit.blade.php ENDPATH**/ ?>