<?php
$inbox = request_count('messages');
$pending_expenses = request_count('pending_expenses');
$leave_application = request_count('leave_application');
$loan_application = request_count('loan_application');
?>

<li>
	<a href="<?php echo e(route('dashboard.index')); ?>"><i class="fas fa-th-large"></i><span><?php echo e(_lang('Dashboard')); ?></span></a>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-user-friends"></i><span><?php echo e(_lang('Employees')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('employees.index')); ?>"><?php echo e(_lang('Manage Employees')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('departments.index')); ?>"><?php echo e(_lang('Departments')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('designations.index')); ?>"><?php echo e(_lang('Designations')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('employees.create')); ?>"><?php echo e(_lang('Add Employee')); ?></a></li>
	</ul>
</li>

<?php if(request()->tenant->package->task_management == 1): ?>
<li>
	<a href="javascript: void(0);"><i class="fas fa-tasks"></i><span><?php echo e(_lang('Task Management')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('tasks.index')); ?>"><?php echo e(_lang('Tasks')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('tasks.create')); ?>"><?php echo e(_lang('New Task')); ?></a></li>
	</ul>
</li>
<?php endif; ?>

<li>
	<a href="javascript: void(0);"><i class="far fa-clock"></i><span><?php echo e(_lang('Manage Work Hours')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('working_hours.create')); ?>"><?php echo e(_lang('Manage Work Hours')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('working_hours.index')); ?>"><?php echo e(_lang('Work Hours History')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-user-clock"></i><span><?php echo e(_lang('Attendance')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('attendance.create')); ?>"><?php echo e(_lang('Manage Attendance')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('attendance.index')); ?>"><?php echo e(_lang('Attendance History')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-money-check-alt"></i><span><?php echo e(_lang('Payslips')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('payslips.index')); ?>"><?php echo e(_lang('Manage Payslip')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('payslips.make_payment')); ?>"><?php echo e(_lang('Make Payment')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-minus-circle"></i><span><?php echo e(_lang('Employee Expenses')); ?></span> <?php echo $pending_expenses > 0 ? xss_clean('<div class="circle-animation"></div>') : ''; ?><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('employee_expenses.index')); ?>"><?php echo e(_lang('Expenses')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('employee_expense_categories.index')); ?>"><?php echo e(_lang('Categories')); ?></a></li>
	</ul>
</li>

<li>
	<a href="<?php echo e(route('holidays.index')); ?>"><i class="fas fa-snowman"></i><span><?php echo e(_lang('Holiday Management')); ?></span></a>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-calendar-alt"></i><span><?php echo e(_lang('Leave Management')); ?></span> <?php echo $leave_application > 0 ? xss_clean('<div class="circle-animation"></div>') : ''; ?><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('leaves.index')); ?>"><?php echo e(_lang('Leave Applications')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('leave_types.index')); ?>"><?php echo e(_lang('Leave Types')); ?></a></li>
	</ul>
</li>

<?php if(request()->tenant->package->loan_management == 1): ?>
<li>
	<a href="javascript: void(0);"><i class="fas fa-coins"></i><span><?php echo e(_lang('Loan Management')); ?></span> <?php echo $loan_application > 0 ? xss_clean('<div class="circle-animation"></div>') : ''; ?><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('employee_loans.index')); ?>?status=pending"><?php echo e(_lang('Pending Loans')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('employee_loans.index')); ?>"><?php echo e(_lang('Manage Loans')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('employee_loans.repayments')); ?>"><?php echo e(_lang('Repayments')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('employee_loan_types.index')); ?>"><?php echo e(_lang('Loan Types')); ?></a></li>
	</ul>
</li>
<?php endif; ?>

<?php if(request()->tenant->package->accounting == 1): ?>
<li>
	<a href="javascript: void(0);"><i class="fas fa-landmark"></i><span><?php echo e(_lang('Accounting')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('accounts.index')); ?>"><?php echo e(_lang('Chart Of Accounts')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('transactions.index')); ?>"><?php echo e(_lang('Transactions')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('transactions.create')); ?>"><?php echo e(_lang('Journal Entry')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('transactions.add_income')); ?>"><?php echo e(_lang('New Income')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('transactions.add_expense')); ?>"><?php echo e(_lang('New Expense')); ?></a></li>
	</ul>
</li>
<?php endif; ?>

<li>
	<a href="<?php echo e(route('awards.index')); ?>"><i class="fas fa-award"></i><span><?php echo e(_lang('Awards')); ?></span></a>
</li>

<li>
	<a href="javascript: void(0);"><i class="far fa-bell"></i><span><?php echo e(_lang('Notices')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('notices.create')); ?>"><?php echo e(_lang('Post Notice')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('notices.index')); ?>"><?php echo e(_lang('Notice List')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-envelope"></i><span><?php echo e(_lang('Messages')); ?></span> <?php echo $inbox > 0 ? xss_clean('<div class="circle-animation"></div>') : ''; ?><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('messages.compose')); ?>"><?php echo e(_lang('New Message')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('messages.inbox')); ?>"><?php echo e(_lang('Inbox Items')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('messages.sent')); ?>"><?php echo e(_lang('Sent Items')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="far fa-chart-bar"></i><span><?php echo e(_lang('Reports')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.attendance_report')); ?>"><?php echo e(_lang('Attendance Report')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.payroll_report')); ?>"><?php echo e(_lang('Payroll Report')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.trialBalance')); ?>"><?php echo e(_lang('Trial Balance')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.generalLedger')); ?>"><?php echo e(_lang('General Ledger')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.profitAndLoss')); ?>"><?php echo e(_lang('Profit & Loss')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.balanceSheet')); ?>"><?php echo e(_lang('Balance Sheet')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-user-friends"></i><span><?php echo e(_lang('System Users')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('users.index')); ?>"><?php echo e(_lang('Manage Users')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('roles.index')); ?>"><?php echo e(_lang('Roles & Permission')); ?></a></li>
	</ul>
</li>

<li><a href="<?php echo e(route('settings.index')); ?>"><i class="fas fa-cog"></i><span><?php echo e(_lang('System Settings')); ?></span></a></li>
<li><a href="<?php echo e(route('email_templates.index')); ?>"><i class="fas fa-envelope-open-text"></i><span><?php echo e(_lang('Notification Templates')); ?></span></a></li><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/layouts/menus/admin.blade.php ENDPATH**/ ?>