<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-10 offset-lg-1">
		<div class="card">
		    <div class="card-header text-center">
				<span class="panel-title"><?php echo e(_lang('Personal Information')); ?></span>
			</div>
			
			<div class="card-body">
			    <table class="table table-bordered">
				    <tr><td colspan="2" class="bg-light"><b><?php echo e(_lang('Personal Details')); ?></b></td></tr>
					<tr>
						<td colspan="2" class="text-center"><img class="thumb-xl rounded" src="<?php echo e(profile_picture($employee->image)); ?>"></td>
					</tr>
				    <tr><td><?php echo e(_lang('Employee ID')); ?></td><td><?php echo e($employee->employee_id); ?></td></tr>
					<tr><td><?php echo e(_lang('First Name')); ?></td><td><?php echo e($employee->first_name); ?></td></tr>
					<tr><td><?php echo e(_lang('Last Name')); ?></td><td><?php echo e($employee->last_name); ?></td></tr>
					<tr><td><?php echo e(_lang('Fathers Name')); ?></td><td><?php echo e($employee->fathers_name); ?></td></tr>
					<tr><td><?php echo e(_lang('Mothers Name')); ?></td><td><?php echo e($employee->mothers_name); ?></td></tr>
					<tr><td><?php echo e(_lang('Date Of Birth')); ?></td><td><?php echo e($employee->date_of_birth); ?></td></tr>
					<tr><td><?php echo e(_lang('Email')); ?></td><td><?php echo e($employee->email); ?></td></tr>
					<tr><td><?php echo e(_lang('Phone')); ?></td><td><?php echo e($employee->phone); ?></td></tr>
					<tr><td><?php echo e(_lang('City')); ?></td><td><?php echo e($employee->city); ?></td></tr>
					<tr><td><?php echo e(_lang('State')); ?></td><td><?php echo e($employee->state); ?></td></tr>
					<tr><td><?php echo e(_lang('Zip')); ?></td><td><?php echo e($employee->zip); ?></td></tr>
					<tr><td><?php echo e(_lang('Country')); ?></td><td><?php echo e($employee->country); ?></td></tr>
					
					<tr><td colspan="2" class="bg-light"><b><?php echo e(_lang('Company Details')); ?></b></td></tr>
					<tr><td><?php echo e(_lang('Department')); ?></td><td><?php echo e($employee->department->name); ?></td></tr>
					<tr><td><?php echo e(_lang('Designation')); ?></td><td><?php echo e($employee->designation->name); ?></td></tr>
					<tr><td><?php echo e(_lang('Salary Type')); ?></td><td><?php echo e(ucwords($employee->salary_type)); ?></td></tr>
					<tr><td><?php echo e(_lang('Basic Salary')); ?></td><td><?php echo e(decimalPlace($employee->basic_salary, currency_symbol(currency()))); ?></td></tr>
					<tr><td><?php echo e(_lang('Full Day Absence Fine')); ?></td><td><?php echo e(decimalPlace($employee->full_day_absence_fine, currency_symbol(currency()))); ?></td></tr>
					<tr><td><?php echo e(_lang('Half Day Absence Fine')); ?></td><td><?php echo e(decimalPlace($employee->half_day_absence_fine, currency_symbol(currency()))); ?></td></tr>
					<tr><td><?php echo e(_lang('Joining Date')); ?></td><td><?php echo e($employee->joining_date); ?></td></tr>
					<?php if($employee->end_date != null): ?>
					<tr><td><?php echo e(_lang('End Date')); ?></td><td><?php echo e($employee->end_date); ?></td></tr>
					<?php endif; ?>
					
					<tr><td colspan="2" class="bg-light"><b><?php echo e(_lang('Bank Details')); ?></b></td></tr>
					<tr><td><?php echo e(_lang('Bank Name')); ?></td><td><?php echo e($employee->bank_name); ?></td></tr>
					<tr><td><?php echo e(_lang('Branch Name')); ?></td><td><?php echo e($employee->branch_name); ?></td></tr>
					<tr><td><?php echo e(_lang('Account Name')); ?></td><td><?php echo e($employee->account_name); ?></td></tr>
					<tr><td><?php echo e(_lang('Account Number')); ?></td><td><?php echo e($employee->account_number); ?></td></tr>
					<tr><td><?php echo e(_lang('Swift Code')); ?></td><td><?php echo e($employee->swift_code); ?></td></tr>
					<tr><td><?php echo e(_lang('Remarks')); ?></td><td><?php echo e($employee->remarks); ?></td></tr>

					<?php if($employee->documents->count() > 0): ?>
					<tr><td colspan="2" class="bg-light"><b><?php echo e(_lang('Documents')); ?></b></td></tr>
					<?php endif; ?>
					<?php $__currentLoopData = $employee->documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e($document->name); ?></td>
						<td><a href="<?php echo e(asset('public/uploads/documents/'.$document->document)); ?>" class="btn btn-xs btn-light"><i class="fas fa-download mr-2"></i><?php echo e(_lang('Download')); ?></a></td>
					</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			    </table>
			</div>
	    </div>
	</div>
</div>

<div class="row">
	<div class="col-lg-5 offset-lg-1">
		<div class="card">
			<div class="card-header">
				<span class="panel-title text-success font-weight-bold"><?php echo e(_lang('Allowances')); ?></span>
			</div>
			<div class="card-body">
				<table class="table table-bordered" id="allowances">
					<thead class="bg-white">
						<th class="text-dark"><?php echo e(_lang('Name')); ?></th>
						<th class="text-dark text-right"><?php echo e(_lang('Amount')); ?></th>
					</thead>
					<tbody>
						<?php $__currentLoopData = $employee->benefit_deductions()->where('type','add')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowances): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td><?php echo e($allowances->name); ?></td>
							<td class="text-right">
								<?php echo e(decimalPlace($allowances->amount, currency_symbol(currency()))); ?>

								<?php echo e($allowances->amount_type == 'percent' ? '%' : ''); ?>

							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>

	<div class="col-lg-5">
		<div class="card">
			<div class="card-header d-flex justify-content-between">
				<span class="panel-title text-danger font-weight-bold"><?php echo e(_lang('Deductions')); ?></span>
			</div>
			<div class="card-body">
				<table class="table table-bordered" id="deductions">
					<thead class="bg-white">
						<th class="text-dark"><?php echo e(_lang('Name')); ?></th>
						<th class="text-dark text-right"><?php echo e(_lang('Amount')); ?></th>
					</thead>
					<tbody>
						<?php $__currentLoopData = $employee->benefit_deductions()->where('type','deduct')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deductions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td><?php echo e($deductions->name); ?></td>
							<td class="text-right">
								<?php echo e(decimalPlace($deductions->amount, currency_symbol(currency()))); ?>

								<?php echo e($deductions->amount_type == 'percent' ? '%' : ''); ?>

							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/employee/job-profile.blade.php ENDPATH**/ ?>