<div class="card">
    <div class="card-header text-center">
        <span class="panel-title"><?php echo e(_lang('Loans')); ?></span>
    </div>
    
    <div class="card-body">
        <div class="table-responsive">
            <table id="payslips_table" class="table table-bordered">
                <thead>
                    <tr>
                        <th><?php echo e(_lang('Date')); ?></th>
                        <th><?php echo e(_lang('Loan ID')); ?></th>
                        <th><?php echo e(_lang('Employee')); ?></th>
                        <th><?php echo e(_lang('Loan Amount')); ?></th>
                        <th><?php echo e(_lang('Remaining Balance')); ?></th>
                        <th><?php echo e(_lang('Interest Rate')); ?></th>
                        <th><?php echo e(_lang('Monthly Installment')); ?></th>
                        <th class="text-center"><?php echo e(_lang('Status')); ?></th>
                        <th class="text-center"><?php echo e(_lang('Action')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($loans->isEmpty()): ?>
                    <tr>
                        <td colspan="9" class="text-center"><?php echo e(_lang('No Loans found')); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loan->application_date); ?></td>
                        <td><?php echo e($employee->employee_id); ?></td>
                        <td><?php echo e($employee->name); ?></td>
                        <td><?php echo e(decimalPlace($loan->loan_amount, currency_symbol())); ?></td>
                        <td><?php echo e(decimalPlace($loan->remaining_balance, currency_symbol())); ?></td>
                        <td><?php echo e($loan->interest_rate); ?>%</td>
                        <td><?php echo e(decimalPlace($loan->monthly_installment, currency_symbol())); ?></td>
                        <td class="text-center">
                            <?php if($loan->status == 'pending'): ?>
                                <span class="badge badge-warning"><?php echo e(ucwords($loan->status)); ?><span>
                            <?php elseif($loan->status == 'approved'): ?>
                                <span class="badge badge-success"><?php echo e(ucwords($loan->status)); ?><span>
                            <?php elseif($loan->status == 'rejected'): ?>
                                <span class="badge badge-danger"><?php echo e(ucwords($loan->status)); ?><span>
                            <?php elseif($loan->status == 'repaid'): ?>
                                <span class="badge badge-primary"><?php echo e(ucwords($loan->status)); ?><span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <a class="btn btn-outline-primary btn-xs" href="<?php echo e(route('employee_loans.show', $loan['id'])); ?>"><i class="fas fa-eye mr-1"></i> <?php echo e(_lang('Details')); ?></a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="float-right">
            <?php echo e($loans->links()); ?>

        </div>
    </div>
</div><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/employee/tabs/loans.blade.php ENDPATH**/ ?>