<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-10 offset-lg-1">
		<div class="card">
			<div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Payroll Report')); ?></span>
				<button class="btn btn-outline-primary btn-xs print" data-print="report" type="button" id="report-print-btn"><i class="fas fa-print mr-1"></i><?php echo e(_lang('Print Report')); ?></button>
			</div>

			<div class="card-body">

				<div class="report-params">
					<form class="validate" method="GET" action="<?php echo e(route('reports.payroll_report')); ?>" autocomplete="off">
						<div class="row">
							<div class="col-xl-3 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Month')); ?></label>						
									<select type="text" class="form-control auto-select" name="month" data-selected="<?php echo e(isset($month) ? $month : old('month', date('m'))); ?>" required>
										<?php for($m = 1; $m <=12; $m++): ?>
										<option value="<?php echo e(date('m', mktime(0, 0, 0, $m, 10))); ?>"><?php echo e(date('F', mktime(0, 0, 0, $m, 10))); ?></option>
										<?php endfor; ?>
									</select>
								</div>
							</div>

							<div class="col-xl-3 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Year')); ?></label>						
									<select type="text" class="form-control auto-select" name="year" data-selected="<?php echo e(isset($year) ? $year : old('year', date('Y'))); ?>" required>
										<?php for($y = 2020; $y <=date('Y'); $y++): ?>
										<option value="<?php echo e($y); ?>"><?php echo e($y); ?></option>
										<?php endfor; ?>
									</select>
								</div>
							</div>

							<div class="col-xl-2 col-lg-4">
								<button type="submit" class="btn btn-light btn-xs btn-block mt-26"><i class="ti-filter mr-1"></i><?php echo e(_lang('Filter')); ?></button>
							</div>
						</form>

					</div>
				</div><!--End Report param-->

				<?php $date_format = get_date_format(); ?>

				<div id="report">
					<div class="report-header">
						<h4><?php echo e(get_tenant_option('business_name', request()->tenant->name)); ?></h4>
						<p><?php echo e(_lang('Payroll Report')); ?></p>
						<p><?php echo e(isset($month) && isset($year) ? date('F', mktime(0, 0, 0, $month, 10)) .', '. $year : ''); ?></p>
					</div>

					<div class="table-responsive">
						<table class="table">
							<thead>
								<th><?php echo e(_lang('Employee ID')); ?></th>
								<th><?php echo e(_lang('Name')); ?></th>
								<th><?php echo e(_lang('Month')); ?></th>
								<th><?php echo e(_lang('Year')); ?></th>
								<th class="text-center"><?php echo e(_lang('Status')); ?></th>
								<th class="text-right"><?php echo e(_lang('Net Salary')); ?></th>
							</thead>
							<tbody>
							<?php if(isset($report_data)): ?>
								<?php $__currentLoopData = $report_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payslip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($payslip->staff->employee_id); ?></td>		
										<td><?php echo e($payslip->staff->name); ?></td>		
										<td><?php echo e(date('F', mktime(0, 0, 0, $payslip->month, 10))); ?></td>
										<td><?php echo e($payslip->year); ?></td>
										<td class="text-center"><?php echo xss_clean(payroll_status($payslip->status)); ?></td>
										<td class="text-right"><?php echo e(decimalPlace($payslip->net_salary, currency_symbol($currency))); ?></td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td colspan="5"><b><?php echo e(_lang('Total Amount')); ?></b></td>		
									<td class="text-right"><?php echo e(decimalPlace($report_data->sum('net_salary'), currency_symbol($currency))); ?></td>
								</tr>
							<?php endif; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/reports/payroll_report.blade.php ENDPATH**/ ?>