<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title"><?php echo e(_lang('Chart Of Accounts')); ?></span>
				<a class="btn btn-primary btn-xs ml-auto ajax-modal-2" data-title="<?php echo e(_lang('Add Account')); ?>" href="<?php echo e(route('accounts.create')); ?>"><i class="ti-plus"></i> <?php echo e(_lang('Add New')); ?></a>
			</div>
			<div class="card-body">
				<table id="accounts_table" class="table data-table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Account ID')); ?></th>
						    <th><?php echo e(_lang('Name')); ?></th>
                            <th><?php echo e(_lang('Type')); ?></th>
                            <th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					    <tr data-id="row_<?php echo e($account->id); ?>">
							<td class='account_id'><?php echo e($account->account_id); ?></td>
							<td class='name'>
								<span class="fw-500"><?php echo e($account->name); ?></span>
								<small class="text-black-50 font-italic"><br><?php echo e(str_replace('_', ' ', $account->slug)); ?></small>
							</td>
							<td class='type'><?php echo e(ucfirst($account->type)); ?></td>

							<td class="text-center">
								<span class="dropdown">
								  <button class="btn btn-outline-primary dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								  <?php echo e(_lang('Action')); ?>

								  </button>
								  <?php if($account->is_default == 0): ?>
								  <form action="<?php echo e(route('accounts.destroy', $account['id'])); ?>" method="post">
									<?php echo e(csrf_field()); ?>

									<input name="_method" type="hidden" value="DELETE">

									<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="<?php echo e(route('accounts.edit', $account['id'])); ?>" data-title="<?php echo e(_lang('Update Account')); ?>" class="dropdown-item dropdown-edit ajax-modal"><i class="fas fa-pencil-alt"></i> <?php echo e(_lang('Edit')); ?></a>
										<button class="btn-remove dropdown-item" type="submit"><i class="fas fa-trash-alt"></i> <?php echo e(_lang('Delete')); ?></button>
									</div>
								  </form>
								  <?php else: ?>
								  	<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="<?php echo e(route('accounts.edit', $account['id'])); ?>" data-title="<?php echo e(_lang('Update Account')); ?>" class="dropdown-item dropdown-edit ajax-modal"><i class="fas fa-pencil-alt"></i> <?php echo e(_lang('Edit')); ?></a>
										<button class="dropdown-item" type="submit" disabled><i class="fas fa-trash-alt"></i> <?php echo e(_lang('Delete')); ?></button>
									</div>
								  <?php endif; ?>
								</span>
							</td>
					    </tr>
					    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/accounts/list.blade.php ENDPATH**/ ?>