<?php $__env->startSection('content'); ?>
<div class="row">
	<?php if(!isset($payslips)): ?>
	<div class="<?php echo e($alert_col); ?>">
		<div class="card">
			<div class="card-header text-center">
				<span class="panel-title"><?php echo e(_lang('Make Payment')); ?></span>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('payslips.make_payment')); ?>" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<div class="row">

						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Month')); ?></label>						
								<select type="text" class="form-control auto-select" name="month" data-selected="<?php echo e(old('month', date('m'))); ?>" required>
									<?php for($m = 1; $m <=12; $m++): ?>
									<option value="<?php echo e(date('m', mktime(0, 0, 0, $m, 10))); ?>"><?php echo e(date('F', mktime(0, 0, 0, $m, 10))); ?></option>
									<?php endfor; ?>
								</select>
							</div>
						</div>

						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Year')); ?></label>						
								<select type="text" class="form-control auto-select" name="year" data-selected="<?php echo e(old('year', date('Y'))); ?>" required>
									<?php for($y = 2020; $y <=date('Y'); $y++): ?>
									<option value="<?php echo e($y); ?>"><?php echo e($y); ?></option>
									<?php endfor; ?>
								</select>
							</div>
						</div>

						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Bank/Cash Account')); ?></label>	
								<select class="form-control select2 auto-select" data-selected="<?php echo e(old('account_id')); ?>" name="account_id" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php $__currentLoopData = App\Models\Account::where('is_bank', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bankAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($bankAccount->id); ?>"><?php echo e($bankAccount->account_id.' - '.$bankAccount->name); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>
			
						<div class="col-md-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary btn-block"><?php echo e(_lang('Next')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
	<?php else: ?>
	<div class="col-lg-10 offset-lg-1">
		<div class="card">
			<div class="card-header text-center">
				<span class="panel-title"><?php echo e(_lang('Make Payment')); ?></span>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('payslips.store_payment')); ?>">
					<?php echo csrf_field(); ?>
					<div class="row">
						<div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <th><?php echo e(_lang('Employee ID')); ?></th>
                                        <th><?php echo e(_lang('Name')); ?></th>
                                        <th><?php echo e(_lang('Month')); ?></th>
                                        <th><?php echo e(_lang('Year')); ?></th>
                                        <th class="text-right"><?php echo e(_lang('Net Salary')); ?></th>
                                        <th class="text-center"><?php echo e(_lang('Status')); ?></th>
                                        <th class="text-center"><?php echo e(_lang('Pay')); ?></th>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $payslips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payslip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($payslip->staff->employee_id); ?></td>
                                            <td><?php echo e($payslip->staff->name); ?></td>
                                            <td><?php echo e(date('F', mktime(0, 0, 0, $payslip->month, 10))); ?></td>
                                            <td><?php echo e($payslip->year); ?></td>
                                            <td class="text-right"><?php echo e(decimalPlace($payslip->net_salary, $currency_symbol)); ?></td>
                                            <td class="text-center"><?php echo xss_clean(payroll_status($payslip->status)); ?></td>
                                            <td class="text-center">
                                                <label class="switch float-none mb-0">
                                                    <input type="checkbox" class="primary product_addon" name="payslip_ids[]" value="<?php echo e($payslip->id); ?>" checked>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
						</div>
				
						<div class="col-md-4 mt-2">
							<div class="form-group">
								<input type="hidden" name="account_id" value="<?php echo e($account_id); ?>">
								<input type="hidden" name="transaction_category_id" value="<?php echo e($transaction_category_id); ?>">
								<button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Make Payment')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
	<?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/payroll/make_payment.blade.php ENDPATH**/ ?>