<form method="post" class="ajax-submit" autocomplete="off" action="<?php echo e(route('leaves.store')); ?>" enctype="multipart/form-data">
	<?php echo csrf_field(); ?>
	<div class="row px-2">
	    <div class="col-md-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Employee ID')); ?></label>						
				<select class="form-control select2 auto-select" data-selected="<?php echo e(old('employee_id')); ?>" name="employee_id"  required>
					<option value=""><?php echo e(_lang('Select One')); ?></option>
					<?php $__currentLoopData = \App\Models\Employee::active()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($employee->id); ?>"><?php echo e($employee->employee_id); ?> (<?php echo e($employee->name); ?>)</option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>
		</div>

		<div class="col-md-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Leave Type')); ?></label>						
				<select class="form-control select2-ajax auto-select" data-selected="<?php echo e(old('leave_type')); ?>" data-table="leave_types" 
				data-value="title" data-display="title" data-where="3" name="leave_type" data-title="<?php echo e(_lang('New Leave Type')); ?>" data-href="<?php echo e(route('leave_types.create')); ?>" required>
					<option value=""><?php echo e(_lang('Select One')); ?></option>
				</select>
			</div>
		</div>
		

		<div class="col-md-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Leave Duration')); ?></label>						
				<select class="form-control auto-select" data-selected="<?php echo e(old('leave_duration')); ?>" name="leave_duration"  required>
					<option value=""><?php echo e(_lang('Select One')); ?></option>
					<option value="full_day"><?php echo e(_lang('Full Day')); ?></option>
					<option value="half_day"><?php echo e(_lang('Half Day')); ?></option>
				</select>
			</div>
		</div>

		<div class="col-md-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Start Date')); ?></label>						
				<input type="text" class="form-control datepicker" name="start_date" value="<?php echo e(old('start_date')); ?>">
			</div>
		</div>

		<div class="col-md-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('End Date')); ?></label>						
				<input type="text" class="form-control datepicker" name="end_date" value="<?php echo e(old('end_date')); ?>">
			</div>
		</div>

		<div class="col-md-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Total Days')); ?></label>						
				<input type="text" class="form-control" name="total_days" id="total_days" value="<?php echo e(old('total_days')); ?>" readonly>
			</div>
		</div>

		<div class="col-md-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Leave Details')); ?></label>						
				<textarea class="form-control" name="description"><?php echo e(old('description')); ?></textarea>
			</div>
		</div>

		<div class="col-md-12 mt-2">
		    <div class="form-group">
			    <button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Submit')); ?></button>
		    </div>
		</div>
	</div>
</form>

<?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/leave/modal/create.blade.php ENDPATH**/ ?>