<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="<?php echo e($alert_col); ?>">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title"><?php echo e(_lang('Add Expense')); ?></span>
			</div>
			<div class="card-body">
                <form class="validate" action="<?php echo e(route('transactions.add_expense')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="transaction_date" class="form-label"><?php echo e(_lang('Transaction Date')); ?></label>
                                <input type="text" class="form-control datepicker" id="transaction_date" name="transaction_date" value="<?php echo e(old('transaction_date', date('Y-m-d'))); ?>" required>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="transaction_date" class="form-label"><?php echo e(_lang('Cash/Bank Account')); ?></label>
                                <select class="form-control select2 auto-select" id="account_id" name="account_id" data-selected="<?php echo e(old('account_id')); ?>" required>
                                    <option value=""><?php echo e(_lang('Select One')); ?></option>
                                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($account->id); ?>">
                                            <?php echo e($account->account_id.' - '.$account->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="transaction_date" class="form-label"><?php echo e(_lang('Expense Category')); ?></label>
                                <select class="form-control select2 auto-select" id="category_id" name="category_id" data-selected="<?php echo e(old('category_id')); ?>" required>
                                    <option value=""><?php echo e(_lang('Select One')); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>">
                                            <?php echo e($category->account_id.' - '.$category->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="description" class="form-label"><?php echo e(_lang('Amount')); ?></label>
                                <input type="text" class="form-control float-field" id="amount" name="amount" value="<?php echo e(old('amount')); ?>" required>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="description" class="form-label"><?php echo e(_lang('Description')); ?></label>
                                <input type="text" class="form-control" id="description" name="description" value="<?php echo e(old('description')); ?>" required>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="attachment" class="form-label"><?php echo e(_lang('Attachment')); ?></label>
                                <input type="file" class="dropify" id="attachment" name="attachment" value="<?php echo e(old('attachment')); ?>">
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <button type="submit" class="btn btn-primary"><i class="fas fa-check-circle mr-1"></i><?php echo e(_lang('Submit')); ?></button>
                        </div>
                    </div>                 
                </form>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/transactions/add_expense.blade.php ENDPATH**/ ?>