<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Departments')); ?></span>
				<div class="d-sm-flex align-items-center mt-2 mt-sm-0">
					<a class="btn btn-info btn-xs" href="<?php echo e(route('designations.index')); ?>"><i class="fas fa-list-ul"></i> <?php echo e(_lang('Designations')); ?></a>
					<a class="btn btn-primary btn-xs ajax-modal ml-0 ml-sm-1" data-title="<?php echo e(_lang('Add Department')); ?>" href="<?php echo e(route('departments.create')); ?>"><i class="ti-plus"></i> <?php echo e(_lang('Add New')); ?></a>
				</div>
			</div>
			<div class="card-body">
				<table id="departments_table" class="table data-table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Name')); ?></th>
							<th><?php echo e(_lang('Descriptions')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					    <tr data-id="row_<?php echo e($department->id); ?>">
							<td class='name'><?php echo e($department->name); ?></td>
							<td class='descriptions'><?php echo e($department->descriptions); ?></td>					
							<td class="text-center">
								<span class="dropdown">
								  <button class="btn btn-outline-primary dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								  <?php echo e(_lang('Action')); ?>

								  </button>
								  <form action="<?php echo e(route('departments.destroy', $department['id'])); ?>" method="post">
									<?php echo e(csrf_field()); ?>

									<input name="_method" type="hidden" value="DELETE">

									<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="<?php echo e(route('departments.edit', $department['id'])); ?>" data-title="<?php echo e(_lang('Update Department')); ?>" class="dropdown-item dropdown-edit ajax-modal"><i class="fas fa-pencil-alt"></i> <?php echo e(_lang('Edit')); ?></a>
										<a href="<?php echo e(route('departments.show', $department['id'])); ?>" data-title="<?php echo e(_lang('Department Details')); ?>" class="dropdown-item dropdown-view ajax-modal"><i class="fas fa-eye"></i> <?php echo e(_lang('Details')); ?></a>
										<button class="btn-remove dropdown-item" type="submit"><i class="fas fa-trash-alt"></i> <?php echo e(_lang('Delete')); ?></button>
									</div>
								  </form>
								</span>
							</td>
					    </tr>
					    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/department/list.blade.php ENDPATH**/ ?>