<div class="card">
    <div class="card-header text-center">
        <span class="panel-title"><?php echo e(_lang('Awards')); ?></span>
    </div>
    
    <div class="card-body">
        <div class="table-responsive">
            <table id="payslips_table" class="table table-bordered">
                <thead>
                    <tr>
                        <th><?php echo e(_lang('Employee ID')); ?></th>
                        <th><?php echo e(_lang('Award Date')); ?></th>
                        <th><?php echo e(_lang('Award Name')); ?></th>
                        <th><?php echo e(_lang('Award')); ?></th>
                        <th class="text-center"><?php echo e(_lang('Action')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($awards->isEmpty()): ?>
                    <tr>
                        <td colspan="5" class="text-center"><?php echo e(_lang('No Awards found')); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php $__currentLoopData = $awards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $award): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($employee->employee_id); ?></td>
                        <td><?php echo e($award->award_date); ?></td>
                        <td><?php echo e($award->name); ?></td>
                        <td><?php echo e($award->award); ?></td>
                        <td class="text-center">
                            <div class="dropdown text-center">
                                <button class="btn btn-outline-primary btn-xs dropdown-toggle" type="button" data-toggle="dropdown"><?php echo e(_lang('Action')); ?></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item ajax-modal" data-title="<?php echo e(_lang('Update Award')); ?>" href="<?php echo e(route('awards.edit', $award['id'])); ?>"><i class="fas fa-pencil-alt mr-1"></i><?php echo e(_lang('Edit')); ?></a>
                                    <a class="dropdown-item ajax-modal" data-title="<?php echo e(_lang('Award Details')); ?>" href="<?php echo e(route('awards.show', $award['id'])); ?>"><i class="fas fa-eye mr-1"></i> <?php echo e(_lang('Details')); ?></a>
                                    <form action="<?php echo e(route('awards.destroy', $award['id'])); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input name="_method" type="hidden" value="DELETE">
                                        <button class="dropdown-item btn-remove" type="submit"><i class="fas fa-trash-alt mr-1"></i> <?php echo e(_lang('Delete')); ?></button>
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="float-right">
            <?php echo e($awards->links()); ?>

        </div>
    </div>
</div><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/employee/tabs/awards.blade.php ENDPATH**/ ?>