<form method="post" class="ajax-submit" autocomplete="off" action="<?php echo e(route('my_expenses.store')); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <div class="row p-2">
        <div class="col-lg-6">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Trans Date')); ?></label>						
                <input type="text" class="form-control datetimepicker" name="trans_date" value="<?php echo e(old('trans_date', now())); ?>" required>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Bill No')); ?></label>						
                <input type="text" class="form-control" name="bill_no" value="<?php echo e(old('bill_no')); ?>">
            </div>
        </div>

        <div class="col-lg-6">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Amount')); ?></label>						
                <input type="text" class="form-control float-field" name="amount" value="<?php echo e(old('amount')); ?>" required>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Category')); ?></label>						
                <select class="form-control select2" name="expense_category_id" required>
                    <option value=""><?php echo e(_lang('Select One')); ?></option>
                    <?php $__currentLoopData = \App\Models\ExpenseCategory::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Description')); ?></label>						
                <textarea class="form-control" name="description" required><?php echo e(old('description')); ?></textarea>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Attachment')); ?></label>						
                <input type="file" class="dropify" name="attachment" >
            </div>
        </div>

        <div class="col-lg-12 mt-2">
            <div class="form-group">
                <button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Submit')); ?></button>
            </div>
        </div>
    </div>
</form><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/employee/employee_expense/modal/create.blade.php ENDPATH**/ ?>