

<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="<?php echo e($alert_col); ?>">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('New Loan Application')); ?></span>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('employee_loans.store')); ?>" enctype="multipart/form-data">
					<?php echo e(csrf_field()); ?>

					<div class="row">
						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Loan ID')); ?></label>
								<input type="text" class="form-control" name="loan_id" value="<?php echo e(old('loan_id')); ?>" required>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Loan Type')); ?></label>
								<select class="form-control auto-select" name="loan_type_id" id="loan_type_id" data-selected="<?php echo e(old('loan_type_id')); ?>" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php $__currentLoopData = \App\Models\LoanType::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($loan_type->id); ?>"><?php echo e($loan_type->name); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Application Date')); ?></label>
								<input type="text" class="form-control datepicker" name="application_date" value="<?php echo e(old('application_date')); ?>" required>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Employee')); ?></label>
								<select class="form-control auto-select select2" data-selected="<?php echo e(old('employee_id')); ?>" name="employee_id" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php $__currentLoopData = \App\Models\Employee::active()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($employee->id); ?>"><?php echo e($employee->employee_id); ?> (<?php echo e($employee->name); ?>)</option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Loan Amount')); ?></label>
								<input type="text" class="form-control float-field" name="loan_amount" id="loan_amount" value="<?php echo e(old('loan_amount')); ?>" required>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Interest Rate')); ?> (%)</label>
								<input type="text" class="form-control float-field" name="interest_rate" id="interest_rate" value="<?php echo e(old('interest_rate')); ?>" readonly>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Interest Type')); ?></label>
								<select class="form-control auto-select" name="interest_type" id="interest_type" data-selected="<?php echo e(old('interest_type', 'fixed')); ?>" disabled>
									<option value="fixed"><?php echo e(_lang('Fixed')); ?></option>
									<option value="declining"><?php echo e(_lang('Declining')); ?></option>
								</select>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Term')); ?></label>
								<input type="number" class="form-control float-field" name="term" id="term" value="<?php echo e(old('term')); ?>" readonly>
							</div>
						</div>

						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Loan Purpose')); ?></label>
								<input type="text" class="form-control" name="loan_purpose" value="<?php echo e(old('loan_purpose')); ?>" required>
							</div>
						</div>

						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Attachment')); ?></label>
								<input type="file" class="dropify" name="attachment">
							</div>
						</div>

						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Description')); ?></label>
								<textarea class="form-control" name="description"><?php echo e(old('description')); ?></textarea>
							</div>
						</div>

						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Remarks')); ?></label>
								<textarea class="form-control" name="remarks"><?php echo e(old('remarks')); ?></textarea>
							</div>
						</div>

						<div class="col-lg-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i><?php echo e(_lang('Submit')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
	"use strict";

	$(document).on('change','#loan_type_id', function(){
		if($(this).val() != ''){
			$.get(_tenant_url + '/employee_loan_types/'+ $(this).val() +'/get_loan_type', function(data, status){
				var json = JSON.parse(JSON.stringify(data));
				$("#interest_rate").val(json['interest_rate']);
				$("#interest_type").val(json['interest_type']);
				$("#term").val(json['term']);
				$("#loan_amount").prop('placeholder',json['minimum_amount'] + ' - ' + json['maximum_amount']);
			});
		}else{
			$("#interest_rate").val('');
			$("#interest_type").val('');
			$("#term").val('');
			$("#loan_amount").prop('placeholder','');
		}
	});

})(jQuery);
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/employee_loans/create.blade.php ENDPATH**/ ?>