<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Tasks')); ?></span>

				<div class="mt-sm-0 mt-2">
					<a class="btn btn-dark btn-xs" href="<?php echo e(route('tasks.kanban')); ?>"><i class="fas fa-stream"></i> <?php echo e(_lang('Kanban View')); ?></a>
					<a class="btn btn-primary btn-xs" href="<?php echo e(route('tasks.create')); ?>"><i class="ti-plus"></i> <?php echo e(_lang('Create New Task')); ?></a>
				</div>
			</div>
			<div class="card-body">
				<table id="tasks_table" class="table">
					<thead>
					    <tr>
                            <th><?php echo e(_lang('Title')); ?></th>
                            <th><?php echo e(_lang('Assigned Users')); ?></th>
                            <th><?php echo e(_lang('Created')); ?></th>
                            <th><?php echo e(_lang('Due Date')); ?></th>
                            <th class="text-center"><?php echo e(_lang('Status')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
	"use strict";

	$('#tasks_table').DataTable({
		processing: true,
		serverSide: true,
		ajax: _tenant_url + '/tasks/get_table_data',
		"columns" : [
			{ data : 'title', name : 'title' },
			{ data : 'users', name : 'users' },
            { data: 'user.name', name: 'user.name' },
            { data: 'due_date', name: 'due_date' },
            { data: 'status', name: 'status' },
			{ data : "action", name : "action" },
		],
		responsive: true,
		"bStateSave": true,
		"bAutoWidth":false,
		"ordering": false,
		"language": {
		   "decimal":        "",
		   "emptyTable":     "<?php echo e(_lang('No Data Found')); ?>",
		   "info":           "<?php echo e(_lang('Showing')); ?> _START_ <?php echo e(_lang('to')); ?> _END_ <?php echo e(_lang('of')); ?> _TOTAL_ <?php echo e(_lang('Entries')); ?>",
		   "infoEmpty":      "<?php echo e(_lang('Showing 0 To 0 Of 0 Entries')); ?>",
		   "infoFiltered":   "(filtered from _MAX_ total entries)",
		   "infoPostFix":    "",
		   "thousands":      ",",
		   "lengthMenu":     "<?php echo e(_lang('Show')); ?> _MENU_ <?php echo e(_lang('Entries')); ?>",
		   "loadingRecords": "<?php echo e(_lang('Loading...')); ?>",
		   "processing":     "<?php echo e(_lang('Processing...')); ?>",
		   "search":         "<?php echo e(_lang('Search')); ?>",
		   "zeroRecords":    "<?php echo e(_lang('No matching records found')); ?>",
		   "paginate": {
			  "first":      "<?php echo e(_lang('First')); ?>",
			  "last":       "<?php echo e(_lang('Last')); ?>",
			  "previous":   "<i class='fas fa-angle-left'></i>",
			  "next":       "<i class='fas fa-angle-right'></i>"
		  }
		}
	});
})(jQuery);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/tasks/index.blade.php ENDPATH**/ ?>