<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Holiday List')); ?></span>

				<div>
					<a class="btn btn-info btn-xs ajax-modal" data-title="<?php echo e(_lang('Manage Weekends')); ?>" href="<?php echo e(route('holidays.weekends')); ?>"><i class="ti-calendar"></i> <?php echo e(_lang('Weekends')); ?></a>
					<a class="btn btn-primary btn-xs ajax-modal" data-title="<?php echo e(_lang('Add Holiday')); ?>" href="<?php echo e(route('holidays.create')); ?>"><i class="ti-plus"></i> <?php echo e(_lang('Add New')); ?></a>
				</div>
			</div>
			<div class="card-body">
				<table id="holidays_table" class="table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Title')); ?></th>
							<th><?php echo e(_lang('Date')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
	"use strict";

	$('#holidays_table').DataTable({
		processing: true,
		serverSide: true,
		ajax: _tenant_url + '/holidays/get_table_data',
		"columns" : [
			{ data : 'title', name : 'title' },
			{ data : 'date', name : 'date' },
			{ data : "action", name : "action" },
		],
		responsive: true,
		"bStateSave": true,
		"bAutoWidth":false,
		"ordering": false,
		"language": {
		   "decimal":        "",
		   "emptyTable":     "<?php echo e(_lang('No Data Found')); ?>",
		   "info":           "<?php echo e(_lang('Showing')); ?> _START_ <?php echo e(_lang('to')); ?> _END_ <?php echo e(_lang('of')); ?> _TOTAL_ <?php echo e(_lang('Entries')); ?>",
		   "infoEmpty":      "<?php echo e(_lang('Showing 0 To 0 Of 0 Entries')); ?>",
		   "infoFiltered":   "(filtered from _MAX_ total entries)",
		   "infoPostFix":    "",
		   "thousands":      ",",
		   "lengthMenu":     "<?php echo e(_lang('Show')); ?> _MENU_ <?php echo e(_lang('Entries')); ?>",
		   "loadingRecords": "<?php echo e(_lang('Loading...')); ?>",
		   "processing":     "<?php echo e(_lang('Processing...')); ?>",
		   "search":         "<?php echo e(_lang('Search')); ?>",
		   "zeroRecords":    "<?php echo e(_lang('No matching records found')); ?>",
		   "paginate": {
			  "first":      "<?php echo e(_lang('First')); ?>",
			  "last":       "<?php echo e(_lang('Last')); ?>",
			  "previous":   "<i class='fas fa-angle-left'></i>",
			  "next":       "<i class='fas fa-angle-right'></i>"
		  }
		}
	});

	$(document).on('click', '#add-row', function(){
		$("#holidays-table").append(`<tr>
							<td>						
								<input type="text" class="form-control" name="title[]" placeholder="<?php echo e(_lang('Title')); ?>" required>
							</td>
							<td>						
								<input type="date" class="form-control" name="date[]" placeholder="<?php echo e(_lang('Date')); ?>" required>
							</td>
							<td class="text-center">						
								<button type="button" class="btn btn-danger btn-xs remove-row"><i class="ti-trash"></i></button>
							</td>
						</tr>`);
	});

	$(document).on('click', '.remove-row', function(){
		$(this).parent().parent().remove();
	});
})(jQuery);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/holiday/list.blade.php ENDPATH**/ ?>