<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-3 col-md-6">
		<div class="card mb-4 dashboard-card">
			<div class="card-body">
				<div class="d-flex">
					<div class="flex-grow-1">
						<h5><?php echo e(_lang('Available Leaves')); ?></h5>
						<h4 class="pt-1 mb-0"><b><?php echo e($available_leave); ?></b></h4>
					</div>
					<div class="ml-2 text-center">
						<i class="fas fa-calendar-alt bg-success text-white"></i>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="col-lg-3 col-md-6">
		<div class="card mb-4 dashboard-card">
			<div class="card-body">
				<div class="d-flex">
					<div class="flex-grow-1">
						<h5><?php echo e(_lang('Leave Taken')); ?></h5>
						<h4 class="pt-1 mb-0"><b><?php echo e($leave_taken); ?></b></h4>
					</div>
					<div class="ml-2 text-center">
						<i class="fas fa-calendar-check bg-primary text-white"></i>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="col-lg-3 col-md-6">
		<div class="card mb-4 dashboard-card">
			<div class="card-body">
				<div class="d-flex">
					<div class="flex-grow-1">
						<h5><?php echo e(_lang('Absent')); ?></h5>
						<h4 class="pt-1 mb-0"><b><?php echo e($absent); ?></b></h4>
					</div>
					<div class="ml-2 text-center">
						<i class="fas fa-calendar-times bg-danger text-white"></i>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="col-lg-3 col-md-6">
		<div class="card mb-4 dashboard-card">
			<div class="card-body">
				<div class="d-flex">
					<div class="flex-grow-1">
						<h5><?php echo e(_lang('Loan Balance')); ?></h5>
						<h4 class="pt-1 mb-0"><b><?php echo e(decimalPlace($loan_balance, currency_symbol())); ?></b></h4>
					</div>
					<div class="ml-2 text-center">
						<i class="fas fa-coins bg-warning text-white"></i>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-lg-6">
		<div class="card">
			<div class="card-header">
				<?php echo e(_lang('Upcoming Holidays')); ?>

			</div>
			<div class="card-body px-0 pt-0">
				<table class="table">
					<thead class="bg-light">
						<tr>
							<th class="text-dark pl-4"><?php echo e(_lang('Title')); ?></th>
							<th class="text-dark"><?php echo e(_lang('Date')); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php if($holidays->count() == 0): ?>
						<tr>
							<td colspan="2" class="text-center"><?php echo e(_lang('No holiday available')); ?></td>
						</tr>
						<?php endif; ?>
						<?php $__currentLoopData = $holidays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holiday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td class="pl-4"><?php echo e($holiday->title); ?></td>
							<td><?php echo e($holiday->date); ?></td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>

	<div class="col-lg-6">
		<div class="card">
			<div class="card-header">
				<?php echo e(_lang('Notice Board')); ?>

			</div>
			<div class="card-body px-0 pt-0">
				<table class="table">
					<thead class="bg-light">
						<tr>
							<th class="text-dark pl-4"><?php echo e(_lang('Title')); ?></th>
							<th class="text-dark"><?php echo e(_lang('Date')); ?></th>
							<th class="text-dark"></th>
						</tr>
					</thead>
					<tbody>
					<?php if($notices->count() == 0): ?>
						<tr>
							<td colspan="2" class="text-center"><?php echo e(_lang('No notice available')); ?></td>
						</tr>
					<?php endif; ?>
					<?php $__currentLoopData = $notices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td class="pl-4"><?php echo e($notice->title); ?></td>
							<td><?php echo e($notice->created_at); ?></td>
							<td class="text-center"><a href="<?php echo e(route('notices.details', $notice->id)); ?>"><i class="fas fa-long-arrow-alt-right mr-1"></i><?php echo e(_lang('View')); ?></a></td>
						</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
				<div class="pl-3"><?php echo e($notices->links()); ?></div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/employee/dashboard-employee.blade.php ENDPATH**/ ?>