<?php $__env->startSection('content'); ?>
<div class="row">
	<?php if(!isset($employees)): ?>
	<div class="col-lg-4 offset-lg-4">
		<div class="card">
			<div class="card-header text-center">
				<span class="panel-title"><?php echo e(_lang('Manage Attendance')); ?></span>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('attendance.create')); ?>" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<div class="row">
						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Date')); ?></label>
								<input type="text" class="form-control datepicker" name="date" value="<?php echo e(old('date')); ?>" required>
							</div>
						</div>

						<div class="col-md-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary btn-block"><?php echo e(_lang('Next')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
	<?php else: ?>
	<div class="col-lg-10 offset-lg-1">
		<?php if($message != null): ?>
		<div class="alert alert-danger">
			<strong><?php echo e($message); ?></strong>
		</div>
		<?php endif; ?>
		<div class="card">
			<div class="card-header text-center">
				<span class="panel-title"><?php echo e(_lang('Manage Attendance')); ?></span>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('attendance.store')); ?>" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<input type="hidden" name="date" value="<?php echo e($date); ?>">
					<div class="row">
						<div class="col-md-12">
							<div class="table-responsive">
								<table class="table table-bordered">
									<thead>
										<th><?php echo e(_lang('Employee ID')); ?></th>
										<th><?php echo e(_lang('Name')); ?></th>
										<th><?php echo e(_lang('Status')); ?></th>
										<th><?php echo e(_lang('Leave/Absent Duration')); ?></th>
										<th><?php echo e(_lang('Remarks')); ?></th>
									</thead>
									<tbody>
										<?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td><?php echo e($employee->employee_id); ?></td>
											<td><?php echo e($employee->name); ?></td>
											<td>
												<input type="hidden" name="employee_id[]" value="<?php echo e($employee->id); ?>">
												<select class="form-control" name="status[]" required>
													<option value="0" <?php echo e($employee->attendance_status == 0 ? 'selected' : ''); ?>><?php echo e(_lang('Absent')); ?></option>
													<option value="1" <?php echo e($employee->attendance_status == 1 ? 'selected' : ''); ?>><?php echo e(_lang('Present')); ?></option>
													<option value="2" <?php echo e($employee->leave_type != null ? 'selected' : ''); ?>><?php echo e(_lang('Leave')); ?></option>
												</select>
											</td>
											<td>
												<select class="form-control" name="leave_duration[]">
													<option value=""><?php echo e(_lang('Select One')); ?></option>
													<option value="full_day" <?php echo e($employee->leave_duration == 'full_day' || $employee->attendance_leave_duration == 'full_day' ? 'selected' : ''); ?>><?php echo e(_lang('Full Day')); ?></option>
													<option value="half_day" <?php echo e($employee->leave_duration == 'half_day' || $employee->attendance_leave_duration == 'half_day' ? 'selected' : ''); ?>><?php echo e(_lang('Half Day')); ?></option>
												</select>
											</td>
											<td>
												<input type="hidden" name="leave_type[]" value="<?php echo e($employee->leave_type); ?>">
												<textarea name="remarks[]" class="form-control"><?php echo e($employee->attendance_remarks == null ? $employee->leave_description : $employee->attendance_remarks); ?></textarea>
											</td>
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tbody>
								</table>
							</div>
						</div>

						<div class="col-md-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Submit')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
	<?php endif; ?>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/attendance/create.blade.php ENDPATH**/ ?>