<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title"><?php echo e(_lang('Loan Types')); ?></span>
				<a class="btn btn-primary btn-xs ml-auto ajax-modal" data-title="<?php echo e(_lang('Add Loan Type')); ?>" href="<?php echo e(route('employee_loan_types.create')); ?>"><i class="ti-plus"></i> <?php echo e(_lang('Add New')); ?></a>
			</div>
			<div class="card-body">
				<table id="employee_loan_types_table" class="table data-table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Name')); ?></th>
							<th><?php echo e(_lang('Minimum Amount')); ?></th>
							<th><?php echo e(_lang('Maximum Amount')); ?></th>
							<th><?php echo e(_lang('Interest Rate')); ?></th>
							<th><?php echo e(_lang('Interest Type')); ?></th>
							<th><?php echo e(_lang('Term')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					    <?php $__currentLoopData = $loantypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loantype): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					    <tr data-id="row_<?php echo e($loantype->id); ?>">
							<td class='name'><?php echo e($loantype->name); ?></td>
							<td class='minimum_amount'><?php echo e(decimalPlace($loantype->minimum_amount, currency_symbol())); ?></td>
							<td class='maximum_amount'><?php echo e(decimalPlace($loantype->maximum_amount, currency_symbol())); ?></td>
							<td class='interest_rate'><?php echo e($loantype->interest_rate); ?>%</td>
							<td class='interest_type'><?php echo e(ucwords($loantype->interest_type)); ?></td>
							<td class='term'><?php echo e($loantype->term); ?></td>
							
							<td class="text-center">
								<span class="dropdown">
								  <button class="btn btn-primary dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								  <?php echo e(_lang('Action')); ?>

								  </button>
								  <form action="<?php echo e(route('employee_loan_types.destroy', $loantype['id'])); ?>" method="post">
									<?php echo e(csrf_field()); ?>

									<input name="_method" type="hidden" value="DELETE">

									<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="<?php echo e(route('employee_loan_types.edit', $loantype['id'])); ?>" data-title="<?php echo e(_lang('Update Loan Type')); ?>" class="dropdown-item dropdown-edit ajax-modal"><i class="fas fa-pencil-alt"></i> <?php echo e(_lang('Edit')); ?></a>
										<a href="<?php echo e(route('employee_loan_types.show', $loantype['id'])); ?>" data-title="<?php echo e(_lang('Loan Type Details')); ?>" class="dropdown-item dropdown-view ajax-modal"><i class="fas fa-eye"></i> <?php echo e(_lang('View')); ?></a>
										<button class="btn-remove dropdown-item" type="submit"><i class="fas fa-trash-alt"></i> <?php echo e(_lang('Delete')); ?></button>
									</div>
								  </form>
								</span>
							</td>
					    </tr>
					    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/loan_types/list.blade.php ENDPATH**/ ?>