<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title"><?php echo e(_lang('Employee Loans')); ?></span>
				<a class="btn btn-primary btn-xs ml-auto" data-title="<?php echo e(_lang('Add New Loan')); ?>" href="<?php echo e(route('employee_loans.create')); ?>"><i class="ti-plus"></i> <?php echo e(_lang('Add New')); ?></a>
			</div>
			<div class="card-body">
				<table id="employee_loans_table" class="table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Date')); ?></th>
						    <th><?php echo e(_lang('Loan ID')); ?></th>
							<th><?php echo e(_lang('Employee')); ?></th>
							<th><?php echo e(_lang('Loan Amount')); ?></th>
							<th><?php echo e(_lang('Remaining Balance')); ?></th>
							<th><?php echo e(_lang('Interest Rate')); ?></th>
							<th><?php echo e(_lang('Monthly Installment')); ?></th>
							<th><?php echo e(_lang('Status')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
	"use strict";

	$('#employee_loans_table').DataTable({
		processing: true,
		serverSide: true,
		ajax: _tenant_url +  '/employee_loans/get_table_data/<?php echo e($status); ?>',
		"columns" : [
			{ data : 'application_date', name : 'application_date' },
			{ data : 'loan_id', name : 'loan_id' },
			{ data : 'employee.first_name', name : 'employee.first_name' },
			{ data : 'loan_amount', name : 'loan_amount' },
			{ data : 'remaining_balance', name : 'remaining_balance' },
			{ data : 'interest_rate', name : 'interest_rate' },
			{ data : 'monthly_installment', name : 'monthly_installment' },
			{ data : 'status', name : 'status' },
			{ data : "action", name : "action" },
		],
		responsive: true,
		"bStateSave": true,
		"bAutoWidth":false,
		"ordering": false,
		"language": {
		   "decimal":        "",
		   "emptyTable":     "<?php echo e(_lang('No Data Found')); ?>",
		   "info":           "<?php echo e(_lang('Showing')); ?> _START_ <?php echo e(_lang('to')); ?> _END_ <?php echo e(_lang('of')); ?> _TOTAL_ <?php echo e(_lang('Entries')); ?>",
		   "infoEmpty":      "<?php echo e(_lang('Showing 0 To 0 Of 0 Entries')); ?>",
		   "infoFiltered":   "(filtered from _MAX_ total entries)",
		   "infoPostFix":    "",
		   "thousands":      ",",
		   "lengthMenu":     "<?php echo e(_lang('Show')); ?> _MENU_ <?php echo e(_lang('Entries')); ?>",
		   "loadingRecords": "<?php echo e(_lang('Loading...')); ?>",
		   "processing":     "<?php echo e(_lang('Processing...')); ?>",
		   "search":         "<?php echo e(_lang('Search')); ?>",
		   "zeroRecords":    "<?php echo e(_lang('No matching records found')); ?>",
		   "paginate": {
			  "first":      "<?php echo e(_lang('First')); ?>",
			  "last":       "<?php echo e(_lang('Last')); ?>",
			  "previous":   "<i class='fas fa-angle-left'></i>",
			  "next":       "<i class='fas fa-angle-right'></i>"
		  }
		}
	});
})(jQuery);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/employee_loans/list.blade.php ENDPATH**/ ?>