<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-xl-3 col-md-6">
		<div class="card mb-4 dashboard-card">
			<div class="card-body">
				<div class="d-flex">
					<div class="flex-grow-1">
						<h5><?php echo e(_lang('Active Employees')); ?></h5>
						<h4 class="pt-1 mb-0"><b><?php echo e($active_employees); ?></b></h4>
					</div>
					<div class="ml-2 text-center">
						<i class="fas fa-users bg-success text-white"></i>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="col-xl-3 col-md-6">
		<a href="<?php echo e(route('leaves.index')); ?>">
			<div class="card mb-4 dashboard-card">
				<div class="card-body">
					<div class="d-flex">
						<div class="flex-grow-1">
							<h5><?php echo e(_lang('Leave Application')); ?></h5>
							<h4 class="pt-1 mb-0"><b><?php echo e(request_count('leave_application')); ?></b></h4>
						</div>
						<div class="ml-2 text-center">
							<i class="fas fa-calendar-alt bg-info text-white"></i>
						</div>
					</div>
				</div>
			</div>
		</a>
	</div>

	<div class="col-xl-3 col-md-6">
		<a href="<?php echo e(route('employee_loans.index',['status' => 'pending'])); ?>">
			<div class="card mb-4 dashboard-card">
				<div class="card-body">
					<div class="d-flex">
						<div class="flex-grow-1">
							<h5><?php echo e(_lang('Loan Application')); ?></h5>
							<h4 class="pt-1 mb-0"><b><?php echo e(request_count('loan_application')); ?></b></h4>
						</div>
						<div class="ml-2 text-center">
							<i class="fas fa-coins bg-primary text-white"></i>
						</div>
					</div>
				</div>
			</div>
		</a>
	</div>

	<div class="col-xl-3 col-md-6">
		<a href="<?php echo e(route('employee_expenses.index')); ?>">
			<div class="card mb-4 dashboard-card">
				<div class="card-body">
					<div class="d-flex">
						<div class="flex-grow-1">
							<h5><?php echo e(_lang('Expenses Requests')); ?></h5>
							<h4 class="pt-1 mb-0"><b><?php echo e(request_count('pending_expenses')); ?></b></h4>
						</div>
						<div class="ml-2 text-center">
							<i class="fas fa-dollar-sign bg-danger text-white"></i>
						</div>
					</div>
				</div>
			</div>
		</a>
	</div>
</div>

<div class="row">
	<div class="col-lg-12">
		<div class="card mb-4">
			<div class="card-header d-flex justify-content-between align-items-center">
				<?php echo e(_lang('Profit & Loss').' - '._lang('Year of').' '.date('Y')); ?>

				<a href="<?php echo e(route('reports.profitAndLoss')); ?>" class="btn btn-outline-primary btn-xs"><i class="far fa-chart-bar mr-1"></i><?php echo e(_lang('View Report')); ?></a>
			</div>
			<div class="card-body">
				<h5 class="text-center loading-chart"><i class="fas fa-spinner fa-spin"></i> <?php echo e(_lang('Loading Chart')); ?></h5>
				<canvas id="transactionAnalysis" style="height: 350px"></canvas>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-lg-12">
		<div class="card mb-4">
			<div class="card-header">
				<?php echo e(_lang('Recent Transactions')); ?>

			</div>
			<div class="card-body p-0">
				<table class="table">
					<thead class="bg-light">
						<tr>
							<th class="text-dark pl-4"><?php echo e(_lang('Date')); ?></th>
						    <th class="text-dark"><?php echo e(_lang('Description')); ?></th>
						    <th class="text-dark"><?php echo e(_lang('Amount')); ?></th>
                            <th class="text-dark text-center"><?php echo e(_lang('Action')); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					    <tr data-id="row_<?php echo e($transaction->id); ?>">
							<td class='created_at pl-4'><?php echo e($transaction->transaction_date); ?></td>
							<td class='description'><?php echo e($transaction->description); ?></td>	
							<td class='amount'><?php echo e(decimalPlace($transaction->entries()->where('type', 'debit')->sum('amount'), currency_symbol())); ?></td>	
							<td class="text-center">
								<span class="dropdown">
								  <button class="btn btn-outline-primary dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								  <?php echo e(_lang('Action')); ?>

								  </button>
								  <form action="<?php echo e(route('transactions.destroy', $transaction['id'])); ?>" method="post">
									<?php echo e(csrf_field()); ?>

									<input name="_method" type="hidden" value="DELETE">

									<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="<?php echo e(route('transactions.show', $transaction['id'])); ?>" class="dropdown-item dropdown-edit"><i class="fas fa-eye"></i> <?php echo e(_lang('Details')); ?></a>
										<a href="<?php echo e(route('transactions.edit', $transaction['id'])); ?>" class="dropdown-item dropdown-edit"><i class="fas fa-pencil-alt"></i> <?php echo e(_lang('Edit')); ?></a>
										<button class="btn-remove dropdown-item" type="submit"><i class="fas fa-trash-alt"></i> <?php echo e(_lang('Delete')); ?></button>
									</div>
								  </form>
								</span>
							</td>
					    </tr>
					    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script src="<?php echo e(asset('public/backend/plugins/chartJs/chart.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/backend/assets/js/dashboard.js?v=1.2')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/dashboard-admin.blade.php ENDPATH**/ ?>