<form method="post" class="validate" autocomplete="off" action="<?php echo e(route('accounts.update', $id)); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <input name="_method" type="hidden" value="PATCH">
    <div class="row px-2">
        <?php if($account->is_default): ?>
        <div class="col-md-12">
            <div class="alert alert-warning">
                <span><i class="fas fa-exclamation-circle mr-1"></i><?php echo e(_lang("You can't change account type of system defined accounts")); ?></span>
            </div>
        </div>
        <?php endif; ?>

        <div class="col-md-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Account ID')); ?></label>						
                <input type="number" class="form-control" name="account_id" value="<?php echo e($account->account_id); ?>" required>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Name')); ?></label>						
                <input type="text" class="form-control" name="name" value="<?php echo e($account->name); ?>" required>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Account Type')); ?></label>						
                <select name="type" class="form-control <?php echo e($account->is_default ? '' : 'select2'); ?> auto-select" data-selected="<?php echo e($account->type); ?>" <?php echo e($account->is_default ? 'disabled' : 'required'); ?>>
                    <option value="asset"><?php echo e(_lang('Asset')); ?></option>
                    <option value="liability"><?php echo e(_lang('Liability')); ?></option>
                    <option value="equity"><?php echo e(_lang('Equity')); ?></option>
                    <option value="revenue"><?php echo e(_lang('Revenue')); ?></option>
                    <option value="expense"><?php echo e(_lang('Expense')); ?></option>
                </select>
            </div>
        </div>

        <div class="col-md-12 <?php echo e($account->type != 'asset' ? 'd-none' : ''); ?>" id="bank-cash-field">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Bank/Cash Account')); ?>?</label>	
                <select class="form-control" name="is_bank" <?php echo e($account->is_default ? 'disabled' : ''); ?>>	
                    <option value="0" <?php echo e($account->is_bank == 0 ? 'selected' : ''); ?>><?php echo e(_lang('No')); ?></option>
                    <option value="1" <?php echo e($account->is_bank == 1 ? 'selected' : ''); ?>><?php echo e(_lang('Yes')); ?></option>
                </select>
            </div>
        </div>
            
        <div class="col-md-12 mt-2">
            <div class="form-group">
                <button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Update')); ?></button>
            </div>
        </div>
    </div>
</form>

<script>
$(document).on('change', '#type', function(){
    $(this).val() == 'asset' ? $("#bank-cash-field").removeClass('d-none') : $("#bank-cash-field").addClass('d-none');
});
</script><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/accounts/modal/edit.blade.php ENDPATH**/ ?>