<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Balance Sheet')); ?></span>
				<button class="btn btn-outline-primary btn-xs print" data-print="report" type="button" id="report-print-btn"><i class="fas fa-print mr-1"></i><?php echo e(_lang('Print Report')); ?></button>
			</div>

			<div class="card-body">
                <div class="report-params">
                    <!-- Date Range Form -->
                    <form method="GET" class="validate" action="<?php echo e(route('reports.balanceSheet')); ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-5">
                                <label for="to_date"><?php echo e(_lang('End Date')); ?></label>
                                <input type="text" name="to_date" class="form-control datepicker" value="<?php echo e($toDate); ?>" readonly>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-light btn-xs btn-block"><i class="ti-filter mr-1"></i><?php echo e(_lang('Filter')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>

                <?php $date_format = get_date_format(); ?>
                <div id="report">
					<div class="report-header">
						<h4><?php echo e(get_tenant_option('business_name', request()->tenant->name)); ?></h4>
						<p><?php echo e(_lang('Balance Sheet')); ?></p>
						<p><?php echo e(isset($toDate) ? date($date_format, strtotime($toDate)) : ''); ?></p>
					</div>

                    <div class="table-responsive mt-2">
                        <table class="table table-bordered">
                            <tbody>
                                <tr class="bg-light">
                                    <td><b><?php echo e(_lang('Assets')); ?></b></td>
                                    <td class="text-right"><b><?php echo e(_lang('Amount')); ?></b></td>
                                </tr>
                                <?php $__currentLoopData = $assetsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="<?php echo e(general_ledger_link($asset['id'])); ?>" target="_blank"><?php echo e($asset['account_name']); ?></a></td>
                                        <td class="text-right"><?php echo e(decimalPlace($asset['balance'])); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><b><?php echo e(_lang('Total Assets')); ?></b></td>
                                    <td class="text-right"><b><?php echo e(decimalPlace(array_sum(array_column($assetsData, 'balance')), $currency_symbol)); ?></b></td>
                                </tr>

                                <tr>
                                    <td colspan="2" class="border-none border-0">&nbsp;</td>
                                </tr>

                                <!--Liabilities-->
                                <tr class="bg-light">
                                    <td class="text-dark"><b><?php echo e(_lang('Liabilities')); ?></b></td>
                                    <td class="text-right"><b><?php echo e(_lang('Amount')); ?></b></td>
                                </tr>
                                <?php $__currentLoopData = $liabilitiesData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $liability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="<?php echo e(general_ledger_link($liability['id'])); ?>" target="_blank"><?php echo e($liability['account_name']); ?></a></td>
                                        <td class="text-right"><?php echo e(decimalPlace($liability['balance'])); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><b><?php echo e(_lang('Total Liabilities')); ?></b></td>
                                    <td class="text-right"><b><?php echo e(decimalPlace(array_sum(array_column($liabilitiesData, 'balance')), $currency_symbol)); ?></b></td>
                                </tr>

                                <tr>
                                    <td colspan="2" class="border-none border-0">&nbsp;</td>
                                </tr>

                                <!--Equity-->
                                <tr class="bg-light">
                                    <td class="text-dark"><b><?php echo e(_lang('Equity')); ?></b></td>
                                    <td class="text-right"><b><?php echo e(_lang('Amount')); ?></b></td>
                                </tr>
                                <?php $__currentLoopData = $equityData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="<?php echo e(general_ledger_link($equity['id'])); ?>" target="_blank"><?php echo e($equity['account_name']); ?></a></td>
                                        <td class="text-right"><?php echo e(decimalPlace($equity['balance'])); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($netProfitOrLoss >= 0 ? _lang('Net Profit') : _lang('Net Loss')); ?></td>
                                    <td class="text-right"><?php echo e(decimalPlace($netProfitOrLoss)); ?></td>
                                </tr>
                                <tr>
                                    <td><b><?php echo e(_lang('Total Equity')); ?><b></td>
                                    <td class="text-right"><b><?php echo e(decimalPlace(array_sum(array_column($equityData, 'balance')) + $netProfitOrLoss, $currency_symbol)); ?></b></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/reports/balance_sheet.blade.php ENDPATH**/ ?>