<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header d-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Payslip')); ?></span>
				<button class="btn btn-primary btn-xs print" type="button" data-print="payslip-report"><i class="fas fa-print"></i> <?php echo e(_lang('Print Payslip')); ?></button>
			</div>
			<div class="card-body" id="payslip-report">
				<div class="text-center">
					<h4 class="mb-2"><?php echo e(_lang('Payslip')); ?></h4>
					<h5><?php echo e(get_tenant_option('business_name', request()->tenant->name)); ?></h5>
					<p><?php echo e(get_option('address')); ?></p>
				</div>

				<table class="w-100 payslip-table mt-4" border="1">
					<tr>
						<td><?php echo e(_lang('Date of Joining')); ?></td>
						<td><?php echo e($payroll->staff->joining_date); ?></td>
						<td><?php echo e(_lang('Employee ID')); ?></td>
						<td><?php echo e($payroll->staff->employee_id); ?></td>
					</tr>
					<tr>
						<td><?php echo e(_lang('Pay Period')); ?></td>
						<td><?php echo e(date('F', mktime(0, 0, 0, $payroll->month, 10))); ?>, <?php echo e($payroll->year); ?></td>
						<td><?php echo e(_lang('Employee Name')); ?></td>
						<td><?php echo e($payroll->staff->name); ?></td>
					</tr>
					<tr>
						<td><?php echo e(_lang('Working Days')); ?></td>
						<td><?php echo e(sprintf("%02d", $working_days)); ?></td>
						<td><?php echo e(_lang('Designation')); ?></td>
						<td><?php echo e($payroll->staff->designation->name); ?></td>
					</tr>
					<?php if($payroll->working_hours != null): ?>
					<tr>
						<td><?php echo e(_lang('Working Hours')); ?></td>
						<td><?php echo e(sprintf("%02d", $payroll->working_hours)); ?></td>
						<td><?php echo e(_lang('Hour Deduct')); ?></td>
						<td><?php echo e(sprintf("%02d", $payroll->hour_deduct)); ?></td>
					</tr>
					<?php endif; ?>
					<tr>
						<td><?php echo e(_lang('Absent')); ?></td>
						<td><?php echo e(is_decimal($absence) ? $absence : sprintf("%02d", $absence)); ?></td>
						<td><?php echo e(_lang('Department')); ?></td>
						<td><?php echo e($payroll->staff->department->name); ?></td>
					</tr>
				</table>

			    <table class="payslip-table w-100 mt-4" border="1">
					<thead class="bg-light">
						<th class="text-dark"><?php echo e(_lang('Allowances')); ?></th>
						<th class="text-dark text-right wp-150"><?php echo e(_lang('Amount')); ?></th>
					</thead>
					<tbody>
						<?php $total_allowances = 0; ?>
						<tr><td><?php echo e(_lang('Basic Salary')); ?></td><td class="text-right"><?php echo e(decimalPlace($payroll->current_salary, $currency_symbol)); ?></td></tr>
						<tr><td><?php echo e(_lang('Expense Claim')); ?></td><td class="text-right"><?php echo e(decimalPlace($payroll->expense, $currency_symbol)); ?></td></tr>
						<?php $__currentLoopData = $payroll->payroll_benefits()->where('type','add')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowances): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

						<?php $allowances_amount = $allowances->amount_type == 'percent' ? ($allowances->amount / 100) * $payroll->current_salary : $allowances->amount; ?>

						<tr><td><?php echo e($allowances->name); ?></td><td class="text-right"><?php echo e(decimalPlace($allowances_amount, $currency_symbol)); ?></td></tr>

						<?php $total_allowances += $allowances_amount; ?>

						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<tr><td><b><?php echo e(_lang('Total Earnings')); ?></b></td><td class="text-right"><b><?php echo e(decimalPlace($payroll->current_salary + $payroll->expense + $total_allowances, $currency_symbol)); ?></b></td></tr>
					</tbody>
				</table>

				<table class="payslip-table w-100 mt-4" border="1">
					<thead class="bg-light">
						<th class="text-dark"><?php echo e(_lang('Deductions')); ?></th>
						<th class="text-dark text-right wp-150"><?php echo e(_lang('Amount')); ?></th>
					</thead>
					<tbody>
						<?php $total_deducations = 0; ?>
						<tr><td><?php echo e(_lang('Absence Fine')); ?></td><td class="text-right"><?php echo e(decimalPlace($payroll->absence_fine, $currency_symbol)); ?></td></tr>
						
						<?php if($payroll->loan > 0): ?>
						<tr><td><?php echo e(_lang('Loan')); ?></td><td class="text-right"><?php echo e(decimalPlace($payroll->loan, $currency_symbol)); ?></td></tr>
						<tr><td><?php echo e(_lang('Loan Interest')); ?></td><td class="text-right"><?php echo e(decimalPlace($payroll->loan_interest, $currency_symbol)); ?></td></tr>
						<?php endif; ?>

						<?php $__currentLoopData = $payroll->payroll_benefits()->where('type','deduct')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deduction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

						<?php $deducation_amount = $deduction->amount_type == 'percent' ? ($deduction->amount / 100) * $payroll->current_salary : $deduction->amount; ?>
						<tr><td><?php echo e($deduction->name); ?></td><td class="text-right"><?php echo e(decimalPlace($deducation_amount, $currency_symbol)); ?></td></tr>

						<?php $total_deducations += $deducation_amount; ?>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

						<tr><td><b><?php echo e(_lang('Total Deductions')); ?></b></td><td class="text-right text-danger"><b><?php echo e(decimalPlace($payroll->absence_fine + $total_deducations + $payroll->loan + $payroll->loan_interest, $currency_symbol)); ?></b></td></tr>
						<tr><td class="text-success"><b><?php echo e(_lang('NET SALARY')); ?></b></td><td class="text-right text-success"><b><?php echo e(decimalPlace($payroll->net_salary, $currency_symbol)); ?></b></td></tr>
					</tbody>
				</table>
			</div>
	    </div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script type="text/javascript">
	document.title = "<?php echo e(_lang('Payslip').'_'.$payroll->staff->name.'_'.date('F', mktime(0, 0, 0, $payroll->month, 10))); ?>,<?php echo e($payroll->year); ?>";
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/payroll/view.blade.php ENDPATH**/ ?>