<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Profit & Loss Report')); ?></span>
				<button class="btn btn-outline-primary btn-xs print" data-print="report" type="button" id="report-print-btn"><i class="fas fa-print mr-1"></i><?php echo e(_lang('Print Report')); ?></button>
			</div>

			<div class="card-body">
                <div class="report-params">
                    <!-- Date Range Form -->
                    <form method="GET" class="validate" action="<?php echo e(route('reports.profitAndLoss')); ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-5">
                                <label for="from_date"><?php echo e(_lang('From Date')); ?></label>
                                <input type="text" name="from_date" class="form-control datepicker" value="<?php echo e($fromDate); ?>" readonly>
                            </div>
                            <div class="col-md-5">
                                <label for="to_date"><?php echo e(_lang('To Date')); ?></label>
                                <input type="text" name="to_date" class="form-control datepicker" value="<?php echo e($toDate); ?>" readonly>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-light btn-xs btn-block"><i class="ti-filter mr-1"></i><?php echo e(_lang('Filter')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>

                <?php $date_format = get_date_format(); ?>

                <div id="report">
					<div class="report-header">
						<h4><?php echo e(get_tenant_option('business_name', request()->tenant->name)); ?></h4>
						<p><?php echo e(_lang('Profit & Loss Report')); ?></p>
						<p><?php echo e(isset($fromDate) ? date($date_format, strtotime($fromDate)).' '._lang('to').' '.date($date_format, strtotime($toDate)) : '----------  '._lang('to').'  ----------'); ?></p>
					</div>

                    <div class="table-responsive mt-2">
                        <table class="table table-bordered">
                            <tbody>
                                <tr class="bg-light">
                                    <td colspan="2"><b><?php echo e(_lang('Revenues')); ?></b></td>
                                </tr>
                                <?php $__currentLoopData = $revenueData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revenue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="<?php echo e(general_ledger_link($revenue['id'])); ?>" target="_blank"><?php echo e($revenue['account_name']); ?></a></td>
                                        <td class="text-right"><?php echo e(decimalPlace($revenue['total'])); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><b><?php echo e(_lang('Total Revenue')); ?></b></td>
                                    <td class="text-right"><b><?php echo e(decimalPlace($totalRevenue, $currency_symbol)); ?></b></td>
                                </tr>

                                <tr>
                                    <td colspan="2" class="border-none border-0">&nbsp;</td>
                                </tr>

                                <!--Cost of Goods Sold-->
                                <?php if(count($cogsData) > 0): ?>
                                <tr class="bg-light">
                                    <td colspan="2" class="text-dark"><b><?php echo e(_lang('Cost of Goods Sold')); ?></b></td>
                                </tr>
                                <?php $__currentLoopData = $cogsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cogs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="<?php echo e(general_ledger_link($cogs['id'])); ?>" target="_blank"><?php echo e($cogs['account_name']); ?></a></td>
                                        <td class="text-right"><?php echo e(decimalPlace($cogs['total'])); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><b><?php echo e($grossProfitOrLoss >= 0 ? _lang('Gross Profit') : _lang('Gross Loss')); ?></b></td>
                                    <td class="text-right"><b><?php echo e(decimalPlace($grossProfitOrLoss, $currency_symbol)); ?></b></td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="border-none border-0">&nbsp;</td>
                                </tr>
                                <?php endif; ?>

                                <!--Expenses-->
                                <tr class="bg-light">
                                    <td colspan="2" class="text-dark"><b><?php echo e(_lang('Expenses')); ?></b></td>
                                </tr>

                                <?php $__currentLoopData = $expenseData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="<?php echo e(general_ledger_link($expense['id'])); ?>" target="_blank"><?php echo e($expense['account_name']); ?></a></td>
                                        <td class="text-right"><?php echo e(decimalPlace($expense['total'])); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><b><?php echo e(_lang('Total Expenses')); ?></b></td>
                                    <td class="text-right"><b><?php echo e(decimalPlace($totalExpenses, $currency_symbol)); ?></b></td>
                                </tr>
                                <tr>
                                    <td><b><?php echo e($netProfitOrLoss >= 0 ? _lang('Net Profit') : _lang('Net Loss')); ?></b></td>
                                    <td class="text-right"><b><?php echo e(decimalPlace($netProfitOrLoss, $currency_symbol)); ?></b></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/reports/profit_and_loss.blade.php ENDPATH**/ ?>