<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title"><?php echo e(_lang('Loan Repayments')); ?></span>
			</div>
			<div class="card-body">
				<table id="loan_repayments_table" class="table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Date')); ?></th>
						    <th><?php echo e(_lang('Loan ID')); ?></th>
                            <th><?php echo e(_lang('Employee ID')); ?></th>
                            <th><?php echo e(_lang('Name')); ?></th>
                            <th><?php echo e(_lang('Principle Amount')); ?></th>
                            <th><?php echo e(_lang('Interest')); ?></th>
					    </tr>
					</thead>
					<tbody>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
	"use strict";

	$('#loan_repayments_table').DataTable({
		processing: true,
		serverSide: true,
		ajax: _url + '/employee/my_loans/get_repayment_table_data',
		"columns" : [
			{ data : 'created_at', name : 'created_at' },
			{ data : 'loan.loan_id', name : 'loan.loan_id' },
			{ data : 'employee.employee_id', name : 'employee.employee_id' },
			{ data : 'employee.first_name', name : 'employee.first_name' },
			{ data : 'principle_amount', name : 'principle_amount' },
			{ data : 'interest', name : 'interest' },
		],
		responsive: true,
		"bStateSave": true,
		"bAutoWidth":false,
		"ordering": false,
		"language": {
		   "decimal":        "",
		   "emptyTable":     "<?php echo e(_lang('No Data Found')); ?>",
		   "info":           "<?php echo e(_lang('Showing')); ?> _START_ <?php echo e(_lang('to')); ?> _END_ <?php echo e(_lang('of')); ?> _TOTAL_ <?php echo e(_lang('Entries')); ?>",
		   "infoEmpty":      "<?php echo e(_lang('Showing 0 To 0 Of 0 Entries')); ?>",
		   "infoFiltered":   "(filtered from _MAX_ total entries)",
		   "infoPostFix":    "",
		   "thousands":      ",",
		   "lengthMenu":     "<?php echo e(_lang('Show')); ?> _MENU_ <?php echo e(_lang('Entries')); ?>",
		   "loadingRecords": "<?php echo e(_lang('Loading...')); ?>",
		   "processing":     "<?php echo e(_lang('Processing...')); ?>",
		   "search":         "<?php echo e(_lang('Search')); ?>",
		   "zeroRecords":    "<?php echo e(_lang('No matching records found')); ?>",
		   "paginate": {
			  "first":      "<?php echo e(_lang('First')); ?>",
			  "last":       "<?php echo e(_lang('Last')); ?>",
			  "previous":   "<i class='fas fa-angle-left'></i>",
			  "next":       "<i class='fas fa-angle-right'></i>"
		  }
		}
	});
})(jQuery);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/employee/employee_loans/loan_repayments.blade.php ENDPATH**/ ?>