<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('General Ledger')); ?></span>
				<button class="btn btn-outline-primary btn-xs print" data-print="report" type="button" id="report-print-btn"><i class="fas fa-print mr-1"></i><?php echo e(_lang('Print Report')); ?></button>
			</div>

			<div class="card-body">
                <div class="report-params">
                    <!-- Date Range Form -->
                    <form method="GET" class="validate" action="<?php echo e(route('reports.generalLedger')); ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="from_date"><?php echo e(_lang('From Date')); ?></label>
                                <input type="text" name="from_date" class="form-control datepicker" value="<?php echo e($fromDate); ?>" readonly>
                            </div>

                            <div class="col-md-3">
                                <label for="to_date"><?php echo e(_lang('To Date')); ?></label>
                                <input type="text" name="to_date" class="form-control datepicker" value="<?php echo e($toDate); ?>" readonly>
                            </div>

                            <div class="col-md-4">
                                <label for="account_id"><?php echo e(_lang('Select Account')); ?></label>
                                <select name="account_id" id="account_id" class="form-control select2">
                                    <option value=""><?php echo e(_lang('All Accounts')); ?></option>
                                    <?php $__currentLoopData = $allAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($account->id); ?>" <?php echo e($accountId == $account->id ? 'selected' : ''); ?>>
                                            <?php echo e($account->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-light btn-xs btn-block"><i class="ti-filter mr-1"></i><?php echo e(_lang('Filter')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>

                <?php $date_format = get_date_format(); ?>

                <div id="report">
					<div class="report-header">
						<h4><?php echo e(get_tenant_option('business_name', request()->tenant->name)); ?></h4>
						<p><?php echo e(_lang('General Ledger')); ?></p>
						<p><?php echo e(isset($fromDate) ? date($date_format, strtotime($fromDate)).' '._lang('to').' '.date($date_format, strtotime($toDate)) : '----------  '._lang('to').'  ----------'); ?></p>
					</div>

                    <?php $__currentLoopData = $generalLedger; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ledger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="table-responsive <?php echo e(!$loop->last ? 'mb-4' : ''); ?>">
                        <table class="table table-bordered">
                            <thead class="bg-light">
                                <tr>
                                    <th class="text-dark" colspan="5"><?php echo e($ledger['account_name']); ?></th>
                                </tr>
                                <tr>
                                    <th class="text-dark"><?php echo e(_lang('Date')); ?></th>
                                    <th class="text-dark"><?php echo e(_lang('Description')); ?></th>
                                    <th class="text-dark text-right"><?php echo e(_lang('Debit')); ?></th>
                                    <th class="text-dark text-right"><?php echo e(_lang('Credit')); ?></th>
                                    <th class="text-dark text-right"><?php echo e(_lang('Balance')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="4"><strong><?php echo e(_lang('Opening Balance')); ?></strong></td>
                                    <td class="text-right"><?php echo e(decimalPlace($ledger['opening_balance'])); ?></td>
                                </tr>
                                <?php $__currentLoopData = $ledger['transactions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($transaction['date']); ?></td>
                                        <td><?php echo e($transaction['description']); ?></td>
                                        <td class="text-right"><?php echo e(decimalPlace($transaction['debit'])); ?></td>
                                        <td class="text-right"><?php echo e(decimalPlace($transaction['credit'])); ?></td>
                                        <td class="text-right"><?php echo e(decimalPlace($transaction['balance'])); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td colspan="4"><strong><?php echo e(_lang('Closing Balance')); ?></strong></td>
                                    <td class="text-right"><?php echo e(decimalPlace($ledger['closing_balance'], $currency_symbol)); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/reports/general_ledger.blade.php ENDPATH**/ ?>