<?php $__env->startSection('content'); ?>
<div class="row">  
    <div class="col-xl-8 offset-xl-2">
        <div id="pricing-table">
            <div class="row">      
                <?php if($package != null): ?>
                <div class="col-lg-6">
                    <div class="pricing-plan popular h-100 <?php echo e($package->package_type == 'monthly' ? 'wow' : ''); ?> animate__zoomIn" data-wow-delay=".6s">
                        <div class="pricing-plan-header">
                            <?php if($package->is_popular == 1): ?>
                            <span><?php echo e(_lang('Most popular')); ?></span>
                            <?php endif; ?>
                            <h5><?php echo e($package->name); ?></h5>
                            <?php if($package->discount > 0): ?>
                            <p class="d-inline-block mb-4">
                                <small><del><?php echo e(decimalPlace($package->cost, currency_symbol())); ?></del></small>
                                <span class="bg-info d-inline-block text-white px-3 py-1 rounded-pill ms-1"><?php echo e($package->discount.'% '._lang('Discount')); ?></span>
                            </p>
                            <h4><span><?php echo e(decimalPlace($package->cost - ($package->discount / 100) * $package->cost, currency_symbol())); ?></span> / <?php echo e(ucwords($package->package_type)); ?></h4>
                            <?php else: ?>
                            <h4><span><?php echo e(decimalPlace($package->cost, currency_symbol())); ?></span> / <?php echo e(ucwords($package->package_type)); ?></h4>
                            <?php endif; ?>
                        </div>
                        <div class="pricing-plan-body">
                            <ul>
                                <li><i class="fas fa-check-circle text-success mr-2"></i><?php echo e(str_replace('-1',_lang('Unlimited'), $package->user_limit).' '._lang('Role Based User')); ?></li>
                                <li><i class="fas fa-check-circle text-success mr-2"></i><?php echo e(str_replace('-1',_lang('Unlimited'), $package->employee_limit).' '._lang('Employee')); ?></li>
                                <li><i class="<?php echo e($package->accounting == 0 ? 'fas fa-times-circle text-danger' : 'fas fa-check-circle text-success'); ?> mr-2"></i><?php echo e(_lang('Accounting')); ?></li>
                                <li><i class="bi <?php echo e($package->task_management == 0 ? 'fas fa-times-circle text-danger' : 'fas fa-check-circle text-success'); ?> mr-2"></i><?php echo e(_lang('Task Management')); ?></li>
                                <li><i class="bi <?php echo e($package->loan_management == 0 ? 'fas fa-times-circle text-danger' : 'fas fa-check-circle text-success'); ?> mr-2"></i><?php echo e(_lang('Loan Management')); ?></li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="card mb-0 mt-4 mt-lg-0">
                        <div class="card-header text-center">
                            <span class="panel-title"><?php echo e(_lang('Membership Details')); ?></span>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped">
                                <tr>
                                    <td><?php echo e(_lang('Membership Type')); ?></td>
                                    <td><?php echo e(ucwords(request()->tenant->membership_type)); ?></td>
                                </tr>
                                <tr>
                                    <td><?php echo e(_lang('Subscription Date')); ?></td>
                                    <td><?php echo e(request()->tenant->subscription_date); ?></td>
                                </tr>
                                <tr>
                                    <td><?php echo e(_lang('Subscription Expired')); ?></td>
                                    <td><?php echo e(request()->tenant->valid_to); ?></td>
                                </tr>
                                <tr>
                                    <td><?php echo e(_lang('Last Payment')); ?></td>
                                    <td><?php echo e($lastPayment ? decimalPlace($lastPayment->amount, currency_symbol()) : _lang('N/A')); ?></td>
                                </tr>
                                <tr>
                                    <td><?php echo e(_lang('Last Payment Date')); ?></td>
                                    <td><?php echo e($lastPayment ? $lastPayment->created_at : _lang('N/A')); ?></td>
                                </tr>
                            </table>
                            <form action="<?php echo e(route('membership.choose_package')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="package_id" value="<?php echo e($package->id); ?>">
                                <a href="<?php echo e(route('membership.payment_gateways')); ?>" class="btn btn-primary btn-block mt-4"><?php echo e(_lang('Renew Membership')); ?></a>
                                <a href="<?php echo e(route('membership.packages')); ?>" class="btn btn-danger btn-block mt-2" id="change-package"><?php echo e(_lang('Change Package')); ?></a>
                            </form>
                        </div>
                    </div>
                </div>

                <?php endif; ?>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <span class="panel-title"><?php echo e(_lang('Subscription Payments')); ?></span>
                    </div>
                    <div class="card-body px-0 pt-0">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th class="pl-4"><?php echo e(_lang('Payment Date')); ?></th>
                                        <th><?php echo e(_lang('Order ID')); ?></th>
                                        <th><?php echo e(_lang('Payment Method')); ?></th>
                                        <th><?php echo e(_lang('Amount')); ?></th>
                                        <th><?php echo e(_lang('Status')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="pl-4"><?php echo e($payment->created_at); ?></td>
                                        <td><?php echo e($payment->order_id); ?></td>
                                        <td><?php echo e($payment->payment_method); ?></td>
                                        <td><?php echo e(decimalPlace($payment->amount, currency_symbol())); ?></td>
                                        <td>
                                            <?php if($payment->status == 1): ?>
                                            <span class="badge badge-success"><?php echo e(_lang('Paid')); ?></span>
                                            <?php else: ?>
                                            <span class="badge badge-danger"><?php echo e(_lang('Unpaid')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table> 
                        </div>

                        <div class="float-right">
                            <?php echo e($payments->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
    "use strict";

    $(document).on('click','#change-package', function(e){
        e.preventDefault();
        var link = $(this).attr('href');

        Swal.fire({
			text: '<?php echo e(_lang('Once you process then you will not able to rollback current subscription. You need to repay for new selected package !')); ?>',
			icon: 'warning',
			showCancelButton: true,
			confirmButtonColor: '#3085d6',
			cancelButtonColor: '#d33',
			confirmButtonText: '<?php echo e(_lang('Yes Process')); ?>',
			cancelButtonText: $lang_cancel_button_text
		}).then((result) => {
			if (result.value) {
				window.location.href = link;
			}
		});
    });
    
})(jQuery);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/membership/index.blade.php ENDPATH**/ ?>