<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="<?php echo e($alert_col); ?>">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Post New Notice')); ?></span>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('notices.store')); ?>" enctype="multipart/form-data">
					<?php echo e(csrf_field()); ?>

					<div class="row">
						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Title')); ?></label>						
								<input type="text" class="form-control" name="title" value="<?php echo e(old('title')); ?>" required>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Details')); ?> <span class="required"> *</span></label>						
								<textarea class="form-control summernote" name="details"><?php echo e(old('details')); ?></textarea>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Attachment')); ?></label>						
								<input type="file" class="form-control file-uploader" data-placeholder="<?php echo e(_lang('Attachment')); ?>" name="attachment" >
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Status')); ?></label>						
								<select class="form-control auto-select" data-selected="<?php echo e(old('status', 1)); ?>" name="status" required>
									<option value="1"><?php echo e(_lang('Published')); ?></option>
									<option value="0"><?php echo e(_lang('Draft')); ?></option>
								</select>
							</div>
						</div>
					
						<div class="col-md-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Submit')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/notice/create.blade.php ENDPATH**/ ?>