<?php $__env->startSection('content'); ?>
<div class="row">
	<?php if(!isset($employees)): ?>
	<div class="<?php echo e($alert_col); ?>">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Manage Working Hour')); ?></span>
			</div>
			<div class="card-body">
			    <form method="get" class="validate" autocomplete="off" action="<?php echo e(route('working_hours.create')); ?>">
					<div class="row">
						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Date')); ?></label>
								<input type="text" class="form-control datepicker no-msg" name="date" value="<?php echo e(old('date')); ?>" required>
							</div>
						</div>

						<div class="col-md-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary btn-block"><?php echo e(_lang('Next')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
	<?php else: ?>
	<div class="<?php echo e($alert_col); ?>">
		<?php if($message != null): ?>
		<div class="alert alert-danger">
			<strong><?php echo e($message); ?></strong>
		</div>
		<?php endif; ?>
		<div class="card">
			<div class="card-header text-center">
				<span class="panel-title"><?php echo e(_lang('Manage Working Hour')); ?></span>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('working_hours.store')); ?>" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<input type="hidden" name="date" value="<?php echo e($date); ?>">
					<div class="row">
						<div class="col-md-12">
							<div class="table-responsive">
								<table class="table table-bordered">
									<thead>
										<th><?php echo e(_lang('Employee ID')); ?></th>
										<th><?php echo e(_lang('Name')); ?></th>
										<th><?php echo e(_lang('Clock In')); ?></th>
										<th><?php echo e(_lang('Clock Out')); ?></th>
										<th><?php echo e(_lang('Hour Deduct')); ?></th>
										<th><?php echo e(_lang('Leave')); ?></th>
										<th><?php echo e(_lang('Remarks')); ?></th>
									</thead>
									<tbody>
										<?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td><?php echo e($employee->employee_id); ?></td>
											<td><?php echo e($employee->name); ?></td>
											<td>
												<input type="hidden" name="employee_id[]" value="<?php echo e($employee->id); ?>">
												<input type="text" name="clock_in[]" class="form-control timepicker clock_in" value="<?php echo e(old('clock_in.'.$loop->index, $employee->clock_in)); ?>" required>	
											</td>
											<td><input type="text" name="clock_out[]" class="form-control timepicker clock_out <?php $__errorArgs = ['clock_out.'.$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('clock_out.'.$loop->index, $employee->clock_out)); ?>" required></td>
											<td><input type="text" name="hour_deduct[]" class="form-control float-field" value="<?php echo e(old('hour_deduct.'.$loop->index, $employee->hour_deduct ?? 0)); ?>" required></td>
											<td>
												<?php echo e($employee->leave_duration != null ? ucwords(str_replace('_',' ',$employee->leave_duration)) : _lang('N/A')); ?>

											</td>
											<td>
												<textarea name="remarks[]" class="form-control"><?php echo e(old('hour_deduct.'.$loop->index, $employee->remarks)); ?></textarea>
											</td>
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tbody>
								</table>
							</div>
						</div>

						<div class="col-md-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Submit')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
	<?php endif; ?>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/working_hour/create.blade.php ENDPATH**/ ?>