<div class="card">
    <div class="card-header text-center">
        <span class="panel-title"><?php echo e(_lang('Leaves')); ?></span>
    </div>
    
    <div class="card-body">
        <div class="table-responsive">
            <table id="payslips_table" class="table table-bordered">
                <thead>
                    <tr>
                        <th><?php echo e(_lang('Employee ID')); ?></th>
                        <th><?php echo e(_lang('Leave Type')); ?></th>
                        <th><?php echo e(_lang('Leave Duration')); ?></th>
                        <th><?php echo e(_lang('Start Date')); ?></th>
                        <th><?php echo e(_lang('End Date')); ?></th>
                        <th><?php echo e(_lang('Total')); ?></th>
                        <th class="text-center"><?php echo e(_lang('Status')); ?></th>
                        <th class="text-center"><?php echo e(_lang('Action')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($leaves->isEmpty()): ?>
                    <tr>
                        <td colspan="8" class="text-center"><?php echo e(_lang('No Leaves found')); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php $__currentLoopData = $leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($employee->employee_id); ?></td>
                        <td><?php echo e($leave->leave_type); ?></td>
                        <td><?php echo e($leave->leave_duration == 'full_day' ? _lang('Full Day') : _lang('Half Day')); ?></td>
                        <td><?php echo e($leave->start_date); ?></td>
                        <td><?php echo e($leave->end_date); ?></td>
                        <td><?php echo e($leave->total_days . ' ' . _lang('days')); ?></td>
                        <td class="text-center"><?php echo xss_clean(leave_status($leave->status)); ?></td>
                        <td class="text-center">
                            <div class="dropdown text-center">
                                <button class="btn btn-outline-primary btn-xs dropdown-toggle" type="button" data-toggle="dropdown"><?php echo e(_lang('Action')); ?></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item ajax-modal" data-title="<?php echo e(_lang('Update Leave')); ?>" href="<?php echo e(route('leaves.edit', $leave['id'])); ?>"><i class="fas fa-pencil-alt mr-1"></i><?php echo e(_lang('Edit')); ?></a>
                                    <a class="dropdown-item ajax-modal" data-title="<?php echo e(_lang('Leave Details')); ?>" href="<?php echo e(route('leaves.show', $leave['id'])); ?>"><i class="fas fa-eye mr-1"></i> <?php echo e(_lang('Details')); ?></a>
                                    <form action="<?php echo e(route('leaves.destroy', $leave['id'])); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input name="_method" type="hidden" value="DELETE">
                                        <button class="dropdown-item btn-remove" type="submit"><i class="fas fa-trash-alt mr-1"></i> <?php echo e(_lang('Delete')); ?></button>
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="float-right">
            <?php echo e($leaves->links()); ?>

        </div>
    </div>
</div><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/employee/tabs/leaves.blade.php ENDPATH**/ ?>