<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="<?php echo e($alert_col); ?>">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Create Task')); ?></span>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('tasks.store')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
					<div class="row">
						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Title')); ?></label>						
								<input type="text" class="form-control" name="title" value="<?php echo e(old('title')); ?>" required>
							</div>
						</div>

                        <div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Due Date')); ?></label>						
								<input type="text" class="form-control datepicker" name="due_date" value="<?php echo e(old('due_date')); ?>" required>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Description')); ?> <span class="required">*</span></label>						
								<textarea class="form-control mini-summernote" name="description"><?php echo e(old('description')); ?></textarea>
							</div>
						</div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?php echo e(_lang('Custom Fields')); ?></label>
                                <div id="customFieldsContainer">
                                    <?php if(old('custom_fields')): ?>
                                        <?php $__currentLoopData = old('custom_fields'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="form-row custom-field-row mb-2">
                                                <div class="col">
                                                    <input type="text" name="custom_fields[<?php echo e($index); ?>][key]" class="form-control" placeholder="Field Name" value="<?php echo e($field['key'] ?? ''); ?>">
                                                </div>
                                                <div class="col">
                                                    <input type="text" name="custom_fields[<?php echo e($index); ?>][value]" class="form-control" placeholder="Field Value" value="<?php echo e($field['value'] ?? ''); ?>">
                                                </div>
                                                <div class="col-auto">
                                                    <button type="button" class="btn btn-danger remove-field"><i class="far fa-trash-alt"></i></button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                                <button type="button" id="addCustomField" class="btn btn-outline-primary btn-xs mt-2"><i class="fas fa-plus-circle"></i> <?php echo e(_lang('Add Custom Field')); ?></button>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="user_ids"><?php echo e(_lang('Assign Users')); ?></label>
                                <select name="user_ids[]" id="user_ids" class="form-control select2" multiple>
                                    <?php $__currentLoopData = $allUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="dependency_ids"><?php echo e(_lang('Task Dependencies')); ?> (<?php echo e(_lang('tasks that must be completed first')); ?>):</label>
                                <select name="dependency_ids[]" id="dependency_ids" class="form-control select2" multiple>
                                    <?php $__currentLoopData = $allTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $depTask): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($depTask->id); ?>"><?php echo e($depTask->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
					
						<div class="col-md-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Submit')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
    "use strict";

    var fieldIndex = $('#customFieldsContainer .custom-field-row').length;
    
    $('#addCustomField').on('click', function(){
         var fieldRow = `<div class="form-row custom-field-row mb-2">
            <div class="col">
                <input type="text" name="custom_fields[`+fieldIndex+`][key]" class="form-control" placeholder="Field Name">
            </div>
            <div class="col">
                <input type="text" name="custom_fields[`+fieldIndex+`][value]" class="form-control" placeholder="Field Value">
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-danger remove-field"><i class="far fa-trash-alt"></i></button>
            </div>
         </div>`;
         $('#customFieldsContainer').append(fieldRow);
         fieldIndex++;
    });
    
    $(document).on('click', '.remove-field', function(){
         $(this).closest('.custom-field-row').remove();
    });
})(jQuery);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/tasks/create.blade.php ENDPATH**/ ?>