<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Leave Management')); ?></span>
				<a class="btn btn-primary btn-xs ajax-modal ml-0 ml-sm-1" data-title="<?php echo e(_lang('New Leave Application')); ?>" href="<?php echo e(route('my_leaves.create')); ?>"><i class="ti-plus"></i> <?php echo e(_lang('New Application')); ?></a>
			</div>
			<div class="card-body">
				<table id="leaves_table" class="table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Employee ID')); ?></th>
							<th><?php echo e(_lang('Leave Type')); ?></th>
							<th><?php echo e(_lang('Leave Duration')); ?></th>
							<th><?php echo e(_lang('Start Date')); ?></th>
							<th><?php echo e(_lang('End Date')); ?></th>
							<th><?php echo e(_lang('Total')); ?></th>
							<th class="text-center"><?php echo e(_lang('Status')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
	"use strict";

	$('#leaves_table').DataTable({
		processing: true,
		serverSide: true,
		ajax: _tenant_url + '/employee/my_leaves/get_table_data',
		"columns" : [
			{ data : 'staff.employee_id', name : 'staff.employee_id' },
			{ data : 'leave_type', name : 'leave_type' },
			{ data : 'leave_duration', name : 'leave_duration' },
			{ data : 'start_date', name : 'start_date' },
			{ data : 'end_date', name : 'end_date' },
			{ data : 'total_days', name : 'total_days' },
			{ data : 'status', name : 'status' },
			{ data : "action", name : "action" },
		],
		responsive: true,
		"bStateSave": true,
		"bAutoWidth":false,
		"ordering": true,
		"language": {
		   "decimal":        "",
		   "emptyTable":     "<?php echo e(_lang('No Data Found')); ?>",
		   "info":           "<?php echo e(_lang('Showing')); ?> _START_ <?php echo e(_lang('to')); ?> _END_ <?php echo e(_lang('of')); ?> _TOTAL_ <?php echo e(_lang('Entries')); ?>",
		   "infoEmpty":      "<?php echo e(_lang('Showing 0 To 0 Of 0 Entries')); ?>",
		   "infoFiltered":   "(filtered from _MAX_ total entries)",
		   "infoPostFix":    "",
		   "thousands":      ",",
		   "lengthMenu":     "<?php echo e(_lang('Show')); ?> _MENU_ <?php echo e(_lang('Entries')); ?>",
		   "loadingRecords": "<?php echo e(_lang('Loading...')); ?>",
		   "processing":     "<?php echo e(_lang('Processing...')); ?>",
		   "search":         "<?php echo e(_lang('Search')); ?>",
		   "zeroRecords":    "<?php echo e(_lang('No matching records found')); ?>",
		   "paginate": {
			  "first":      "<?php echo e(_lang('First')); ?>",
			  "last":       "<?php echo e(_lang('Last')); ?>",
			  "previous":   "<i class='fas fa-angle-left'></i>",
			  "next":       "<i class='fas fa-angle-right'></i>"
		  }
		}
	});

	$(document).on('change', 'input[name=start_date], input[name=end_date]', function(){
		var startDate = $('input[name=start_date]').val();
		var endDate = $('input[name=end_date]').val();
		$('#total_days').val(0);
		if(startDate != '' && endDate != ''){
			var start_date = new Date(startDate);
			var end_date = new Date(endDate);
			var total_days = (end_date - start_date) / 1000 / 60 / 60 / 24 + 1;
			if(total_days > 0){
				$('#total_days').val(total_days);
			}
		}
	});

})(jQuery);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/employee/leave/list.blade.php ENDPATH**/ ?>