<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title"><?php echo e(_lang('Trial Balance')); ?></span>
				<button class="btn btn-outline-primary btn-xs print" data-print="report" type="button" id="report-print-btn"><i class="fas fa-print mr-1"></i><?php echo e(_lang('Print Report')); ?></button>
			</div>

			<div class="card-body">
                <div class="report-params">
                    <!-- Date Range Form -->
                    <form method="GET" class="validate" action="<?php echo e(route('reports.trialBalance')); ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-5">
                                <label for="from_date"><?php echo e(_lang('From Date')); ?></label>
                                <input type="text" name="from_date" class="form-control datepicker" value="<?php echo e($fromDate); ?>" readonly>
                            </div>
                            <div class="col-md-5">
                                <label for="to_date"><?php echo e(_lang('To Date')); ?></label>
                                <input type="text" name="to_date" class="form-control datepicker" value="<?php echo e($toDate); ?>" readonly>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-light btn-xs btn-block"><i class="ti-filter mr-1"></i><?php echo e(_lang('Filter')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>

                <?php $date_format = get_date_format(); ?>

                <div id="report">
					<div class="report-header">
						<h4><?php echo e(get_tenant_option('business_name', request()->tenant->name)); ?></h4>
						<p><?php echo e(_lang('Trial Balance')); ?></p>
						<p><?php echo e(isset($fromDate) ? date($date_format, strtotime($fromDate)).' '._lang('to').' '.date($date_format, strtotime($toDate)) : '----------  '._lang('to').'  ----------'); ?></p>
					</div>
					
					<div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="bg-light">
                                <tr>
                                    <th class="text-dark"><?php echo e(_lang('Account')); ?></th>
                                    <th class="text-dark text-right"><?php echo e(_lang('Debit')); ?></th>
                                    <th class="text-dark text-right"><?php echo e(_lang('Credit')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $trialBalance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $balance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="<?php echo e(general_ledger_link($balance['id'])); ?>" target="_blank"><?php echo e($balance['account_name']); ?></a></td>
                                        <td class="text-right"><?php echo e(decimalPlace($balance['debit'])); ?></td>
                                        <td class="text-right"><?php echo e(decimalPlace($balance['credit'])); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th><?php echo e(_lang('Total')); ?></th>
                                    <th class="text-right"><?php echo e(decimalPlace($totalDebits, $currency_symbol)); ?></th>
                                    <th class="text-right"><?php echo e(decimalPlace($totalCredits, $currency_symbol)); ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/reports/trial_balance.blade.php ENDPATH**/ ?>