<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="<?php echo e($alert_col); ?>">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title"><?php echo e(_lang('Update Journal entry')); ?></span>
			</div>
			<div class="card-body">
                <form class="validate" action="<?php echo e(route('transactions.update', $transaction->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="form-group">
                                <label for="transaction_date" class="form-label"><?php echo e(_lang('Transaction Date')); ?></label>
                                <input type="text" class="form-control datepicker" id="transaction_date" name="transaction_date" value="<?php echo e(old('transaction_date', $transaction->getRawOriginal('transaction_date'))); ?>" required>
                            </div>
                        </div>

                        <div class="col-lg-9">
                            <div class="form-group">
                                <label for="description" class="form-label"><?php echo e(_lang('Description')); ?></label>
                                <input type="text" class="form-control" id="description" name="description" value="<?php echo e(old('description', $transaction->description)); ?>" required>
                            </div>
                        </div>
                    </div>

                    <table class="table table-bordered mt-4" id="entries-table">
                        <thead class="bg-light">
                            <tr>
                                <th class="text-dark pl-3"><?php echo e(_lang('Account')); ?></th>
                                <th class="text-dark"><?php echo e(_lang('Type')); ?></th>
                                <th class="text-dark"><?php echo e(_lang('Amount')); ?></th>
                                <th class="text-dark text-center"><?php echo e(_lang('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($transaction->entries): ?>
                                <?php $__currentLoopData = $transaction->entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="pl-3">
                                            <select class="form-control select2" data-placeholder="<?php echo e(_lang('Select Account')); ?>" name="entries[<?php echo e($index); ?>][account_id]" required>
                                                <option></option>
                                                <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accountType => $chartOfAccounts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <optgroup label="<?php echo e(ucwords($accountType)); ?>">
                                                    <?php $__currentLoopData = $chartOfAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($account->id); ?>" <?php echo e($entry->account_id == $account->id ? 'selected' : ''); ?>><?php echo e($account->account_id.' - '.$account->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </optgroup>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
                                        <td>
                                            <select class="form-control entry-type" name="entries[<?php echo e($index); ?>][type]" required>
                                                <option value="debit" <?php echo e($entry->type == 'debit' ? 'selected' : ''); ?>><?php echo e(_lang('Debit')); ?></option>
                                                <option value="credit" <?php echo e($entry->type == 'credit' ? 'selected' : ''); ?>><?php echo e(_lang('Credit')); ?></option>
                                            </select>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control float-field entry-amount <?php $__errorArgs = ['entries.'.$loop->index.'.amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="entries[<?php echo e($index); ?>][amount]" value="<?php echo e($entry->amount); ?>" required>
                                        </td>
                                        <td class="text-center">
                                            <button type="button" class="btn btn-danger btn-xs remove-entry"><i class="far fa-trash-alt mr-1"></i><?php echo e(_lang('Remove')); ?></button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td class="pl-3">
                                        <select class="form-control select2" data-placeholder="<?php echo e(_lang('Select Account')); ?>" name="entries[0][account_id]" required>
                                            <option></option>
                                            <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accountType => $chartOfAccounts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <optgroup label="<?php echo e(ucwords($accountType)); ?>">
                                                <?php $__currentLoopData = $chartOfAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($account->id); ?>"><?php echo e($account->account_id.' - '.$account->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </optgroup>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </td>
                                    <td>
                                        <select class="form-control entry-type" name="entries[0][type]" required>
                                            <option value="debit" selected><?php echo e(_lang('Debit')); ?></option>
                                            <option value="credit"><?php echo e(_lang('Credit')); ?></option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control float-field entry-amount" name="entries[0][amount]" required>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-xs remove-entry"><i class="far fa-trash-alt mr-1"></i><?php echo e(_lang('Remove')); ?></button>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="pl-3">
                                        <select class="form-control select2" data-placeholder="<?php echo e(_lang('Select Account')); ?>" name="entries[1][account_id]" required>
                                            <option></option>
                                            <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accountType => $chartOfAccounts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <optgroup label="<?php echo e(ucwords($accountType)); ?>">
                                                <?php $__currentLoopData = $chartOfAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($account->id); ?>"><?php echo e($account->account_id.' - '.$account->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </optgroup>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </td>
                                    <td>
                                        <select class="form-control entry-type" name="entries[1][type]" required>
                                            <option value="debit"><?php echo e(_lang('Debit')); ?></option>
                                            <option value="credit" selected><?php echo e(_lang('Credit')); ?></option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control float-field entry-amount" name="entries[1][amount]" required>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-xs remove-entry"><i class="far fa-trash-alt mr-1"></i><?php echo e(_lang('Remove')); ?></button>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>

                    <table class="table table-bordered bg-light">
                        <tr>
                            <td class=" border border-primary font-weight-bold w-50">
                                <span><?php echo e(_lang('TOTAL DEBIT AMOUNT')); ?>:</span>
                                <span class="float-right" id="total-debit"></span>
                            </td>
                            <td class=" border border-primary font-weight-bold w-50">
                                <span><?php echo e(_lang('TOTAL CREDIT AMOUNT')); ?>:</span>
                                <span class="float-right" id="total-credit"></span>
                            </td>                          
                        </tr>
                    </table>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="attachment" class="form-label"><?php echo e(_lang('Attachment')); ?></label>
                                <input type="file" class="dropify" id="attachment" name="attachment" data-default-file="<?php echo e($transaction->attachment != null ? asset('storage/app/public/'. $transaction->attachment) : ''); ?>">
                            </div>
                        </div>
                    </div>

                    <button type="button" id="add-entry" class="btn btn-secondary"><i class="fas fa-plus-circle mr-1"></i><?php echo e(_lang('Add Another Entry')); ?></button>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-check-circle mr-1"></i><?php echo e(_lang('Submit Transaction')); ?></button>
                </form>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        let entryIndex = <?php echo e(old('entries') ? count(old('entries')) : 2); ?>;

        document.getElementById('add-entry').addEventListener('click', function () {
            const tableBody = document.querySelector('#entries-table tbody');
            const newRow = document.createElement('tr');

            newRow.innerHTML = `
                <td class="pl-3">
                    <select class="form-control select2" data-placeholder="<?php echo e(_lang('Select Account')); ?>" name="entries[${entryIndex}][account_id]" required>
                        <option></option>
                        <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accountType => $chartOfAccounts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <optgroup label="<?php echo e(ucwords($accountType)); ?>">
                            <?php $__currentLoopData = $chartOfAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($account->id); ?>"><?php echo e($account->account_id.' - '.$account->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td>
                    <select class="form-control entry-type" name="entries[${entryIndex}][type]" required>
                        <option value="debit"><?php echo e(_lang('Debit')); ?></option>
                        <option value="credit"><?php echo e(_lang('Credit')); ?></option>
                    </select>
                </td>
                <td>
                    <input type="text" class="form-control float-field entry-amount" name="entries[${entryIndex}][amount]" required>
                </td>
                <td class="text-center">
                    <button type="button" class="btn btn-danger btn-xs remove-entry"><i class="far fa-trash-alt mr-1"></i><?php echo e(_lang('Remove')); ?></button>
                </td>
            `;
            tableBody.appendChild(newRow);
            entryIndex++;

            $(".select2").select2();

            updateTotals();
        });

        document.querySelector('#entries-table').addEventListener('click', function (e) {
            if (e.target && e.target.classList.contains('remove-entry')) {
                const row = e.target.closest('tr');
                row.remove();
            }
        });

        document.querySelector('#entries-table').addEventListener('input', function (e) {
            if (e.target && e.target.classList.contains('entry-amount')) {
                updateTotals();
            }
        });

        document.querySelector('#entries-table').addEventListener('change', function (e) {
            if (e.target && e.target.classList.contains('entry-type')) {
                updateTotals();
            }
        });

        document.querySelector('#entries-table').addEventListener('click', function (e) {
            if (e.target && e.target.classList.contains('remove-entry')) {
                e.target.closest('tr').remove();
                updateTotals();
            }
        });

        function updateTotals() {
            let totalDebit = 0;
            let totalCredit = 0;

            document.querySelectorAll('#entries-table tbody tr').forEach(row => {
                const type = row.querySelector('.entry-type').value;
                const amount = parseFloat(row.querySelector('.entry-amount').value) || 0;

                if (type === 'debit') {
                    totalDebit += amount;
                } else if (type === 'credit') {
                    totalCredit += amount;
                }
            });

            document.getElementById('total-debit').textContent = totalDebit.toFixed(2);
            document.getElementById('total-credit').textContent = totalCredit.toFixed(2);
        }

        updateTotals();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cloudxhostingx/public_html/account.cloudxhosting.us/resources/views/backend/admin/transactions/edit.blade.php ENDPATH**/ ?>