<?php

use App\Http\Controllers\AccountController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\AwardController;
use App\Http\Controllers\CommentController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\DesignationController;
use App\Http\Controllers\EmailTemplateController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\EmployeeDocumentController;
use App\Http\Controllers\EmployeeExpenseController;
use App\Http\Controllers\Employee\AwardController as EmployeeAwardController;
use App\Http\Controllers\Employee\EmployeeExpenseController as ExpenseController;
use App\Http\Controllers\Employee\LeaveController as EmployeeLeaveController;
use App\Http\Controllers\Employee\LoanController as EmployeeLoanController;
use App\Http\Controllers\Employee\PayrollController as EmployeePayrollController;
use App\Http\Controllers\Employee\ReportController as EmployeeReportController;
use App\Http\Controllers\Employee\WorkingHourController as EmployeeWorkingHourController;
use App\Http\Controllers\ExpenseCategoryController;
use App\Http\Controllers\HolidayController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\LeaveTypeController;
use App\Http\Controllers\LoanController;
use App\Http\Controllers\LoanTypeController;
use App\Http\Controllers\MembershipController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\NoticeController;
use App\Http\Controllers\PayrollController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SuperAdmin\BackupController;
use App\Http\Controllers\SuperAdmin\ContactController;
use App\Http\Controllers\SuperAdmin\DashboardController as SuperAdminDashboardController;
use App\Http\Controllers\SuperAdmin\EmailSubscriberController;
use App\Http\Controllers\SuperAdmin\FaqController;
use App\Http\Controllers\SuperAdmin\FeatureController;
use App\Http\Controllers\SuperAdmin\LanguageController;
use App\Http\Controllers\SuperAdmin\NotificationTemplateController;
use App\Http\Controllers\SuperAdmin\OfflineMethodController;
use App\Http\Controllers\SuperAdmin\PackageController;
use App\Http\Controllers\SuperAdmin\PageController;
use App\Http\Controllers\SuperAdmin\PaymentGatewayController;
use App\Http\Controllers\SuperAdmin\PostController;
use App\Http\Controllers\SuperAdmin\SubscriptionPaymentController;
use App\Http\Controllers\SuperAdmin\TeamController;
use App\Http\Controllers\SuperAdmin\TenantController;
use App\Http\Controllers\SuperAdmin\TestimonialController;
use App\Http\Controllers\SuperAdmin\UtilityController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\TenantSettingsController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Website\WebsiteController;
use App\Http\Controllers\WorkingHourController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

$ev = env('APP_INSTALLED', true) == true && get_option('email_verification', 0) == 1 ? true : false;

Route::group(['middleware' => ['install']], function () use ($ev) {

    Route::prefix('admin')->group(function () {
        Route::get('/', function () {
            return redirect()->route('admin.login');
        });
        Route::get('/login', [LoginController::class, 'showAdminLoginForm'])->name('admin.login');
        Route::post('/login', [LoginController::class, 'login'])->name('admin.login');
        Route::get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('admin.password.request');
        Route::post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('admin.password.email');
        Route::get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('admin.password.reset');
        Route::post('password/reset', 'Auth\ResetPasswordController@reset')->name('admin.password.update');
    });

    Route::prefix('{tenant}')->middleware('tenant')->group(function () {
        Route::get('/login', [LoginController::class, 'showTenantLoginForm'])->name('tenant.login');
        Route::post('/login', [LoginController::class, 'login'])->name('tenant.login');
        Route::get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('tenant.password.request');
        Route::post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('tenant.password.email');
        Route::get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('tenant.password.reset');
        Route::post('password/reset', 'Auth\ResetPasswordController@reset')->name('tenant.password.update');
    });

    Auth::routes([
        'login'  => false,
        'reset'  => false,
        'verify' => $ev,
    ]);
    Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [LoginController::class, 'showTenants']);
    Route::get('/logout', [LoginController::class, 'logout']);

    $initialMiddleware = ['auth'];
    if ($ev == 1) {
        array_push($initialMiddleware, 'verified');
    }

    Route::group(['middleware' => $initialMiddleware], function () {

        /** Super Admin Only Routes **/
        Route::name('admin.')->prefix('admin')->middleware(['superadmin'])->group(function () {
            Route::get('dashboard', [SuperAdminDashboardController::class, 'index'])->name('dashboard.index');

            //Profile Controller
            Route::get('profile', [ProfileController::class, 'index'])->name('profile.index');
            Route::get('profile/edit', [ProfileController::class, 'edit'])->name('profile.edit');
            Route::post('profile/update', [ProfileController::class, 'update'])->name('profile.update')->middleware('demo');
            Route::get('profile/change_password', [ProfileController::class, 'change_password'])->name('profile.change_password');
            Route::post('profile/update_password', [ProfileController::class, 'update_password'])->name('profile.update_password')->middleware('demo');
            Route::get('profile/notification_mark_as_read/{id}', [ProfileController::class, 'notification_mark_as_read'])->name('profile.notification_mark_as_read');
            Route::get('profile/show_notification/{id}', [ProfileController::class, 'show_notification'])->name('profile.show_notification');

            //Subscription Payments
            Route::get('subscription_payments/{id}/approve_payout_requests', [SubscriptionPaymentController::class, 'approve_payment_requests'])->name('subscription_payments.approve_payment_requests');
            Route::match(['get', 'post'], 'subscription_payments/{id}/reject_payout_requests', [SubscriptionPaymentController::class, 'reject_payment_requests'])->name('subscription_payments.reject_payment_requests');
            Route::get('subscription_payments/get_table_data', [SubscriptionPaymentController::class, 'get_table_data']);
            Route::resource('subscription_payments', SubscriptionPaymentController::class)->except([
                'destroy',
            ])->middleware("demo:PUT|PATCH|DELETE");

            //Tenant Controller
            Route::post('tenants/send_email', [TenantController::class, 'send_email'])->name('tenants.send_email')->middleware('demo');
            Route::get('tenants/get_table_data', [TenantController::class, 'get_table_data']);
            Route::resource('tenants', TenantController::class)->middleware("demo:PUT|PATCH|DELETE");

            Route::group(['middleware' => 'demo'], function () {

                //Language Controller
                Route::get('languages/{lang}/edit_website_language', [LanguageController::class, 'edit_website_language'])->name('languages.edit_website_language');
                Route::resource('languages', LanguageController::class);

                //Utility Controller
                Route::match(['get', 'post'], 'general_settings/{store?}', [UtilityController::class, 'settings'])->name('settings.update_settings');
                Route::post('upload_logo', [UtilityController::class, 'upload_logo'])->name('settings.uplaod_logo')->middleware("demo");
                Route::post('remove_cache', [UtilityController::class, 'remove_cache'])->name('settings.remove_cache');
                Route::post('send_test_email', [UtilityController::class, 'send_test_email'])->name('settings.send_test_email');

                //Data Backup
                Route::get('backups', [BackupController::class, 'index'])->name('backup.index');
                Route::get('backups/create', [BackupController::class, 'create_backup'])->name('backup.create')->middleware("demo:GET");
                Route::get('backups/restore', [BackupController::class, 'show_restore_form'])->name('backup.restore');
                Route::post('backups/restore', [BackupController::class, 'restore_backup'])->name('backup.restore')->middleware("demo");
                Route::get('backups/{file}/download', [BackupController::class, 'download'])->name('backup.download')->middleware("demo:GET");
                Route::delete('backups/{file}/destroy', [BackupController::class, 'destroy'])->name('backup.destroy');

                //Notification Template
                Route::resource('notification_templates', NotificationTemplateController::class)->only([
                    'index', 'edit', 'update', 'show',
                ])->middleware("demo");

                //Package Controller
                Route::resource('packages', PackageController::class);

                //Payment Gateways
                Route::resource('payment_gateways', PaymentGatewayController::class)->except([
                    'create', 'store', 'show', 'destroy',
                ]);

                //Offline Gateways
                Route::resource('offline_methods', OfflineMethodController::class)->except('show');

                //Page Controller
                Route::post('pages/store_default_pages/{slug?}', [PageController::class, 'store_default_pages'])->name('pages.default_pages.store');
                Route::get('pages/default_pages/{slug?}', [PageController::class, 'default_pages'])->name('pages.default_pages');
                Route::resource('pages', PageController::class)->except('show');

                //FAQ Controller
                Route::resource('faqs', FaqController::class)->except('show');

                //Features Controller
                Route::resource('features', FeatureController::class)->except('show');

                //Testimonial Controller
                Route::resource('testimonials', TestimonialController::class)->except('show');

                //Team Controller
                Route::resource('posts', PostController::class)->except('show');

                //Team Controller
                Route::resource('teams', TeamController::class)->except('show');

                //Email Subscribers
                Route::match(['get', 'post'], 'email_subscribers/send_email', [EmailSubscriberController::class, 'send_email'])->name('email_subscribers.send_email');
                Route::get('email_subscribers/export', [EmailSubscriberController::class, 'export'])->name('email_subscribers.export');
                Route::get('email_subscribers/get_table_data', [EmailSubscriberController::class, 'get_table_data']);
                Route::get('email_subscribers', [EmailSubscriberController::class, 'index'])->name('email_subscribers.index');
                Route::delete('email_subscribers/{id}/destroy', [EmailSubscriberController::class, 'destroy'])->name('email_subscribers.destroy');

                //Contact Messages
                Route::get('contact_messages/get_table_data', [ContactController::class, 'get_table_data']);
                Route::resource('contact_messages', ContactController::class)->only(['index', 'show', 'destroy']);
            });
        });

        //Tenant Dashboard
        Route::prefix('{tenant}')->middleware(['tenant', 'tenant.global'])->group(function () {
            Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard.index');

            //Profile Controller
            Route::get('profile', [ProfileController::class, 'index'])->name('profile.index');
            Route::get('profile/edit', [ProfileController::class, 'edit'])->name('profile.edit');
            Route::post('profile/update', [ProfileController::class, 'update'])->name('profile.update')->middleware('demo');
            Route::get('profile/change_password', [ProfileController::class, 'change_password'])->name('profile.change_password');
            Route::post('profile/update_password', [ProfileController::class, 'update_password'])->name('profile.update_password')->middleware('demo');
            Route::get('profile/notification_mark_as_read/{id}', [ProfileController::class, 'notification_mark_as_read'])->name('profile.notification_mark_as_read');
            Route::get('profile/show_notification/{id}', [ProfileController::class, 'show_notification'])->name('profile.show_notification');

            //Message Controllers
            Route::get('/messages/compose', [MessageController::class, 'compose'])->name('messages.compose');
            Route::post('/messages/send', [MessageController::class, 'send'])->name('messages.send');
            Route::get('/messages/inbox', [MessageController::class, 'inbox'])->name('messages.inbox');
            Route::get('/messages/sent', [MessageController::class, 'sentItems'])->name('messages.sent');
            Route::get('/messages/{id}', [MessageController::class, 'show'])->name('messages.show');
            Route::get('/messages/reply/{id}', [MessageController::class, 'reply'])->name('messages.reply');
            Route::post('/messages/reply/{id}', [MessageController::class, 'sendReply'])->name('messages.sendReply');
            Route::get('/messages/{id}/download_attachment', [MessageController::class, 'download_attachment'])->name('messages.download_attachment');

            // Task Controller
            Route::get('tasks/get_table_data', [TaskController::class, 'get_table_data']);
            Route::get('tasks/kanban', [TaskController::class, 'kanban'])->name('tasks.kanban');
            Route::resource('tasks', TaskController::class);
            Route::put('tasks/{task}/update_status', [TaskController::class, 'update_status']);
            Route::put('tasks/{subTask}/update_sub_task_status', [TaskController::class, 'update_sub_task_status']);
            Route::post('tasks/{task}/comments', [CommentController::class, 'add_comment'])->name('tasks.add_comment');
            Route::post('tasks/{task}/subtasks', [TaskController::class, 'add_sub_task'])->name('tasks.add_sub_task');
            Route::post('tasks/{task}/upload-file', [TaskController::class, 'upload_file'])->name('tasks.upload_file');
            Route::post('tasks/{task}/assign-users', [TaskController::class, 'assign_users'])->name('tasks.assign_users');

            //Get Loan Type By ID
            Route::get('employee_loan_types/{id}/get_loan_type', [LoanTypeController::class, 'get_loan_type']);

            //Ajax Select2 Controller
            Route::get('ajax/get_table_data', 'Select2Controller@get_table_data');

            /** Tenant Admin Only Routes **/
            Route::middleware('tenant.admin')->group(function () {
                Route::get('membership', [MembershipController::class, 'index'])->name('membership.index');

                //User Management
                Route::get('users/get_table_data', [UserController::class, 'get_table_data']);
                Route::resource('users', UserController::class)->middleware("demo:PUT|PATCH|DELETE");

                //User Roles
                Route::resource('roles', 'RoleController')->middleware("demo:PUT|PATCH|DELETE");

                //Permission Controller
                Route::get('permission/access_control', 'PermissionController@index')->name('permission.index');
                Route::get('permission/access_control/{user_id?}', 'PermissionController@show')->name('permission.show');
                Route::post('permission/store', 'PermissionController@store')->name('permission.store');

                //Tenant Settings Controller
                Route::post('settings/upload_logo', [TenantSettingsController::class, 'upload_logo'])->name('settings.upload_logo');
                Route::post('settings/send_test_email', [TenantSettingsController::class, 'send_test_email'])->name('settings.send_test_email');
                Route::post('settings/store_email_settings', [TenantSettingsController::class, 'store_email_settings'])->name('settings.store_email_settings');
                Route::post('settings/store_currency_settings', [TenantSettingsController::class, 'store_currency_settings'])->name('settings.store_currency_settings');
                Route::post('settings/store_general_settings', [TenantSettingsController::class, 'store_general_settings'])->name('settings.store_general_settings');
                Route::get('settings', [TenantSettingsController::class, 'index'])->name('settings.index');

                //Notification Template
                Route::resource('email_templates', EmailTemplateController::class)->only([
                    'index', 'edit', 'update', 'show',
                ])->middleware("demo");
            });

            /** Tenant Role based user Routes **/
            Route::middleware('tenant.user')->group(function () {
                //Dashboard Widget
                Route::get('dashboard/active_employee_widget', 'DashboardController@dashboard_widget')->name('dashboard.active_employee_widget');
                Route::get('dashboard/leave_application_widget', 'DashboardController@dashboard_widget')->name('dashboard.leave_application_widget');
                Route::get('dashboard/loan_application_widget', 'DashboardController@dashboard_widget')->name('dashboard.loan_application_widget');
                Route::get('dashboard/expense_requests_widget', 'DashboardController@dashboard_widget')->name('dashboard.expense_requests_widget');
                Route::get('dashboard/profit_and_loss_widget', 'DashboardController@dashboard_widget')->name('dashboard.profit_and_loss_widget');
                Route::get('dashboard/recent_transactions_widget', 'DashboardController@dashboard_widget')->name('dashboard.recent_transactions_widget');

                //Department Controller
                Route::resource('departments', DepartmentController::class)->middleware("demo:PUT|PATCH|DELETE");
                Route::get('designations/get_designations/{deaprtment_id}', [DesignationController::class, 'get_designations']);
                Route::resource('designations', DesignationController::class)->except('show')->middleware("demo:PUT|PATCH|DELETE");

                //Staff Controller
                Route::match(['get', 'post'], 'employees/{id}/login_access', [EmployeeController::class, 'login_access'])->name('employees.login_access')->middleware("demo");
                Route::get('employees/get_table_data', [EmployeeController::class, 'get_table_data']);
                Route::resource('employees', EmployeeController::class)->middleware("demo:PUT|PATCH|DELETE");

                //Staff Documents
                Route::get('employee_documents/{employee_id}', [EmployeeDocumentController::class, 'index'])->name('employee_documents.index');
                Route::get('employee_documents/create/{employee_id}', [EmployeeDocumentController::class, 'create'])->name('employee_documents.create');
                Route::resource('employee_documents', EmployeeDocumentController::class)->except(['index', 'create', 'show'])->middleware("demo:PUT|PATCH|DELETE");

                //Holiday Controller
                Route::get('holidays/get_table_data', [HolidayController::class, 'get_table_data']);
                Route::match(['get', 'post'], 'holidays/weekends', [HolidayController::class, 'weekends'])->name('holidays.weekends');
                Route::resource('holidays', HolidayController::class)->except('show')->middleware("demo:PUT|PATCH|DELETE");

                //Leave Application
                Route::resource('leave_types', LeaveTypeController::class)->except('show')->middleware("demo:PUT|PATCH|DELETE");
                Route::get('leaves/{id}/reject', [LeaveController::class, 'reject'])->name('leaves.reject');
                Route::get('leaves/{id}/approve', [LeaveController::class, 'approve'])->name('leaves.approve');
                Route::get('leaves/get_table_data', [LeaveController::class, 'get_table_data']);
                Route::resource('leaves', LeaveController::class)->middleware("demo:PUT|PATCH|DELETE");

                //Working Hours
                Route::get('working_hours/get_table_data', [WorkingHourController::class, 'get_table_data']);
                Route::resource('working_hours', WorkingHourController::class)->except('show');

                //Attendance Controller
                Route::get('attendance/get_table_data', [AttendanceController::class, 'get_table_data']);
                Route::post('attendance/create', [AttendanceController::class, 'create'])->name('attendance.create');
                Route::resource('attendance', AttendanceController::class)->except('show', 'edit', 'update', 'destroy');

                //Expense Category
                Route::resource('employee_expense_categories', ExpenseCategoryController::class)->except('show')->middleware("demo:PUT|PATCH|DELETE");

                //Employee Expense Controller
                Route::get('employee_expenses/get_table_data', [EmployeeExpenseController::class, 'get_table_data']);
                Route::resource('employee_expenses', EmployeeExpenseController::class);

                //Award Controller
                Route::get('awards/get_table_data', [AwardController::class, 'get_table_data']);
                Route::resource('awards', AwardController::class);

                //Payslip Controller
                Route::post('payslips/store_payment', [PayrollController::class, 'store_payment'])->name('payslips.store_payment');
                Route::match(['get', 'post'], 'payslips/make_payment', [PayrollController::class, 'make_payment'])->name('payslips.make_payment');
                Route::get('payslips/get_table_data', [PayrollController::class, 'get_table_data']);
                Route::resource('payslips', PayrollController::class);

                //Chart Of Accounts
                Route::resource('accounts', AccountController::class)->except('show')->middleware("demo:PUT|PATCH|DELETE");

                //Transaction Controller
                Route::get('transactions/get_table_data', [TransactionController::class, 'get_table_data']);
                Route::match(['get', 'post'], 'transactions/add_income', [TransactionController::class, 'add_income'])->name('transactions.add_income');
                Route::match(['get', 'post'], 'transactions/add_expense', [TransactionController::class, 'add_expense'])->name('transactions.add_expense');
                Route::resource('transactions', TransactionController::class);

                //Loan Type Controller
                Route::resource('employee_loan_types', LoanTypeController::class)->middleware("demo:PUT|PATCH|DELETE");

                //Loan Controller
                Route::get('employee_loans/get_repayment_table_data', [LoanController::class, 'get_repayment_table_data']);
                Route::get('employee_loans/repayments', [LoanController::class, 'repayments'])->name('employee_loans.repayments');
                Route::get('employee_loans/{id}/reject', [LoanController::class, 'reject'])->name('employee_loans.reject');
                Route::match(['get', 'post'], 'employee_loans/{id}/approve', [LoanController::class, 'approve'])->name('employee_loans.approve');
                Route::get('employee_loans/get_table_data/{status?}', [LoanController::class, 'get_table_data']);
                Route::resource('employee_loans', LoanController::class);

                //Notice Controller
                Route::get('notices/get_table_data', [NoticeController::class, 'get_table_data']);
                Route::resource('notices', NoticeController::class);

                //Report Controller
                Route::get('reports/attendance_report', [ReportController::class, 'attendance_report'])->name('reports.attendance_report');
                Route::get('reports/payroll_report', [ReportController::class, 'payroll_report'])->name('reports.payroll_report');
                Route::get('/reports/general-ledger', [ReportController::class, 'generalLedger'])->name('reports.generalLedger');
                Route::get('/reports/trial-balance', [ReportController::class, 'trialBalance'])->name('reports.trialBalance');
                Route::get('/reports/profit-and-loss', [ReportController::class, 'profitAndLoss'])->name('reports.profitAndLoss');
                Route::get('/reports/balance-sheet', [ReportController::class, 'balanceSheet'])->name('reports.balanceSheet');
            });

            /** Tenant employee Routes **/
            Route::prefix('employee')->middleware('tenant.employee')->group(function () {
                Route::middleware(['check.ip'])->group(function () {
                    Route::post('clock_in', [EmployeeWorkingHourController::class, 'clock_in'])->name('clock.in');
                    Route::post('clock_out', [EmployeeWorkingHourController::class, 'clock_out'])->name('clock.out');
                });

                //Profile Details
                Route::get('profile/job_profile', [ProfileController::class, 'job_profile'])->name('profile.job_profile');

                //View Notice
                Route::get('notices/{id}/details', [DashboardController::class, 'notice_details'])->name('notices.details');

                //Payslip Application
                Route::get('my_payslips/get_table_data', [EmployeePayrollController::class, 'get_table_data']);
                Route::resource('my_payslips', EmployeePayrollController::class)->only('index', 'show');

                //Leave Application
                Route::get('my_leaves/get_table_data', [EmployeeLeaveController::class, 'get_table_data']);
                Route::resource('my_leaves', EmployeeLeaveController::class)->except('edit', 'update', 'destroy');

                //Employee Expense Controller
                Route::get('my_expenses/get_table_data', [ExpenseController::class, 'get_table_data']);
                Route::resource('my_expenses', ExpenseController::class)->except('edit', 'update', 'destroy');

                //Loan Controller
                Route::get('my_loans/get_repayment_table_data', [EmployeeLoanController::class, 'get_repayment_table_data']);
                Route::get('my_loans/repayments', [EmployeeLoanController::class, 'repayments'])->name('my_loans.repayments');
                Route::get('my_loans/get_table_data/{status?}', [EmployeeLoanController::class, 'get_table_data']);
                Route::resource('my_loans', EmployeeLoanController::class)->except('edit', 'update', 'destroy');

                //Award Controller
                Route::get('my_awards/get_table_data', [EmployeeAwardController::class, 'get_table_data']);
                Route::resource('my_awards', EmployeeAwardController::class)->only('index', 'show');

                //Report Controller
                Route::get('my_reports/attendance_report', [EmployeeReportController::class, 'attendance_report'])->name('my_reports.attendance_report');
                Route::get('my_reports/work_hour_report', [EmployeeReportController::class, 'work_hour_report'])->name('my_reports.work_hour_report');

            });
        });
    });

    Route::get('switch_language/', function () {
        if (isset($_GET['language'])) {
            session(['language' => $_GET['language']]);
            return back();
        }
    })->name('switch_language');

    Route::get('tenants/check-tenant-slug/{ignoreId?}', [TenantController::class, 'checkSlug'])->name('check-slug');

    //Frontend Website
    Route::get('/about', [WebsiteController::class, 'about']);
    Route::get('/features', [WebsiteController::class, 'features']);
    Route::get('/pricing', [WebsiteController::class, 'pricing']);
    Route::get('/faq', [WebsiteController::class, 'faq']);
    Route::get('/blogs/{slug?}', [WebsiteController::class, 'blogs']);
    Route::get('/contact', [WebsiteController::class, 'contact']);
    Route::post('/send_message', 'Website\WebsiteController@send_message');
    Route::post('/post_comment', 'Website\WebsiteController@post_comment');
    Route::post('/email_subscription', 'Website\WebsiteController@email_subscription');

    if (env('APP_INSTALLED', true)) {
        Route::get('/{slug?}', [WebsiteController::class, 'index']);
    } else {
        Route::get('/', function () {
            echo "Installation";
        });
    }
});

//Dashboard Widget
Route::get('dashboard/json_profit_and_loss', 'DashboardController@json_profit_and_loss')->middleware('auth');

Route::get('admin/dashboard/json_package_wise_subscription', 'SuperAdmin\DashboardController@json_package_wise_subscription')->middleware('auth');
Route::get('admin/dashboard/json_yearly_revenue', 'SuperAdmin\DashboardController@json_yearly_revenue')->middleware('auth');
Route::get('admin/dashboard/json_yearly_signup', 'SuperAdmin\DashboardController@json_yearly_signup')->middleware('auth');

//Subscription Payment
Route::group(['prefix' => 'subscription_callback', 'namespace' => 'SubscriptionGateway'], function () {
    Route::get('paypal', 'PayPal\ProcessController@callback')->name('subscription_callback.PayPal');
    Route::post('stripe', 'Stripe\ProcessController@callback')->name('subscription_callback.Stripe');
    Route::post('razorpay', 'Razorpay\ProcessController@callback')->name('subscription_callback.Razorpay');
    Route::get('paystack', 'Paystack\ProcessController@callback')->name('subscription_callback.Paystack');
    Route::get('flutterwave', 'Flutterwave\ProcessController@callback')->name('subscription_callback.Flutterwave');
    Route::get('mollie', 'Mollie\ProcessController@callback')->name('subscription_callback.Mollie');
    Route::match(['get', 'post'], 'instamojo', 'Instamojo\ProcessController@callback')->name('subscription_callback.Instamojo');
    Route::post('offline_payment/{slug}', 'Offline\ProcessController@callback')->name('subscription_callback.offline');
});

//Membership Subscription
Route::get('membership/packages', [MembershipController::class, 'packages'])->name('membership.packages');
Route::post('membership/choose_package', [MembershipController::class, 'choose_package'])->name('membership.choose_package');
Route::get('membership/payment_gateways', [MembershipController::class, 'payment_gateways'])->name('membership.payment_gateways');
Route::get('membership/make_payment/{gateway}', [MembershipController::class, 'make_payment'])->name('membership.make_payment');

//Social Login
Route::get('/login/{provider}', 'Auth\SocialController@redirect');
Route::get('/login/{provider}/callback', 'Auth\SocialController@callback');

Route::get('/installation', 'Install\InstallController@index');
Route::get('install/database', 'Install\InstallController@database');
Route::post('install/process_install', 'Install\InstallController@process_install');
Route::get('install/create_user', 'Install\InstallController@create_user');
Route::post('install/store_user', 'Install\InstallController@store_user');
Route::get('install/system_settings', 'Install\InstallController@system_settings');
Route::post('install/finish', 'Install\InstallController@final_touch');

//Update System
Route::get('system/update/{action?}', 'Install\UpdateController@index');
Route::get('migration/update', 'Install\UpdateController@update_migration');
