@extends('layouts.app')

@section('content')
<div class="row">
	<div class="{{ $alert_col }}">
        <!-- Bootstrap 4.6 Nav Tabs -->
        <ul class="nav nav-tabs business-settings-tabs" id="taskTabs" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="details-tab" data-toggle="tab" href="#details" role="tab"><i class="fas fa-tasks"></i> {{ _lang('Task Details') }}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="dependencies-tab" data-toggle="tab" href="#dependencies" role="tab"><i class="fas fa-truck-loading"></i> {{ _lang('Dependencies') }}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="comments-tab" data-toggle="tab" href="#comments" role="tab"><i class="far fa-comment"></i> {{ _lang('Comments') }}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="subtasks-tab" data-toggle="tab" href="#subtasks" role="tab"><i class="fas fa-tasks"></i> {{ _lang('Sub Tasks') }}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="files-tab" data-toggle="tab" href="#files" role="tab"><i class="fas fa-paperclip"></i> {{ _lang('Attachments') }}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="assign-tab" data-toggle="tab" href="#assign" role="tab"><i class="fas fa-user-plus"></i> {{ _lang('Assign Users') }}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="log-tab" data-toggle="tab" href="#task-log" role="tab"><i class="far fa-list-alt"></i> {{ _lang('Task Activity') }}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="assign-tab" href="{{ route('tasks.edit', $task->id) }}"><i class="far fa-edit"></i> {{ _lang('Edit Task') }}</a>
            </li>
        </ul>

        @php $buttonColors = ['To_Do'=> 'btn-danger', 'In_Progress' => 'btn-primary', 'Completed' => 'btn-success']; @endphp

        <!-- Tab Content -->
        <div class="tab-content mt-3" id="taskTabsContent">
            <!-- Task Details Tab -->
            <div class="tab-pane fade show active" id="details" role="tabpanel">
                <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <span class="panel-title">{{ _lang('Task Details') }}</span>
                        <div class="dropdown">
                            <button class="btn {{ $buttonColors[$task->status] }} btn-xs dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false">
                                {{ str_replace('_', ' ', $task->status) }}
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item update-task-status" href="#" data-status="To_Do" data-task-id="{{ $task->id }}"><i class="fas fa-hourglass-half text-danger"></i> {{ _lang('Mark as To Do') }}</a>
                                <a class="dropdown-item update-task-status" href="#" data-status="In_Progress" data-task-id="{{ $task->id }}"><i class="far fa-check-circle text-primary"></i> {{ _lang('Mark as In Progress') }}</a>
                                <a class="dropdown-item update-task-status" href="#" data-status="Completed" data-task-id="{{ $task->id }}"><i class="fas fa-check-circle text-success"></i> {{ _lang('Mark as Completed') }}</a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-body">
                        <div class="row">
                            <!-- Task Information -->
                            <div class="col-12">
                                <div class="d-flex align-items-center">
                                    <p class="text-primary mr-1"><i class="fas fa-tag fs-14"></i></p>
                                    <p class="text-primary">{{ _lang('Title') }}</p>
                                </div>
                                <p class="font-weight-bold">{{ $task->title }}</p>

                                <div class="d-flex align-items-center mt-3">
                                    <p class="text-primary mr-1"><i class="far fa-calendar-alt fs-14"></i></p>
                                    <p class="text-primary">{{ _lang('Due Date') }}</p>
                                </div>
                                <p><span class="badge badge-danger">{{ $task->due_date }}</span></p>

                                <div class="d-flex align-items-center mt-4">
                                    <p class="text-primary mr-1"><i class="fas fa-align-left fs-14"></i> </p>
                                    <p class="text-primary">{{ _lang('Description') }}</p>
                                </div>
                                <p class="text-justify">{!! xss_clean($task->description) !!}</p>
                            </div>
                        </div>

                        <!-- Custom Fields -->
                        @if($task->custom_fields)
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex align-items-center">
                                    <p class="text-primary mr-1"><i class="fas fa-list fs-14"></i></p>
                                    <p class="text-primary">{{ _lang('Additional Information') }}</p>
                                </div>
                                <div class="table-responsive mt-1">
                                    <table class="table mb-0">
                                        @foreach($task->custom_fields as $key => $value)
                                        <tr>
                                            <td class="font-weight-bold text-nowrap pl-0">{{ $key }}</td>
                                            <td class="w-100">{{ $value }}</td>
                                        </tr>
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                        @endif

                        @if($task->users->count() > 0)
                        <!-- Assigned Users -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex align-items-center">
                                    <p class="text-primary mr-1"><i class="fas fa-user-friends fs-14"></i></p>
                                    <p class="text-primary">{{ _lang('Assigned Users') }}</p>
                                </div>
                                <ul class="list-group mt-1">
                                    @foreach($task->users as $user)
                                    <li class="list-group-item d-flex align-items-center">
                                        <i class="fas fa-user-circle text-primary mr-2"></i> {{ $user->name }}
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Dependencies Tab -->
            <div class="tab-pane fade" id="dependencies" role="tabpanel">
                <div class="card">
                    <div class="card-header text-center">
                        <span class="panel-title">{{ _lang('Task Dependencies') }}</span>
                    </div>
                    
                    <div class="card-body">
                        @if($task->dependencies->count() > 0)
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="d-flex align-items-center">
                                    <p class="text-primary mr-1"><i class="fas fa-list-ul fs-14"></i></p> 
                                    <p class="text-primary">{{ _lang('Task Dependencies') }}</p>
                                </div>
                                <ul class="list-group mt-2">
                                    @foreach($task->dependencies as $dependency)
                                    <li class="list-group-item d-flex align-items-center">
                                        <i class="{{ $dependency->status == 'Completed' ? 'fas fa-check-circle text-success' : 'fas fa-hourglass-half text-danger' }} mr-2"></i>{{ $dependency->title }}
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        @endif

                        @if($task->dependents->count() > 0)
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex align-items-center">
                                    <p class="text-primary mr-1"><i class="fas fa-list-ul fs-14"></i></p>
                                    <p class="text-primary">{{ _lang('Dependent Tasks') }}</p>
                                </div>
                                <ul class="list-group mt-2">
                                    @foreach($task->dependents as $dependent)
                                    <li class="list-group-item d-flex align-items-center">
                                        <i class="{{ $dependent->status == 'Completed' ? 'fas fa-check-circle text-success' : 'fas fa-hourglass-half text-danger' }} mr-2"></i>{{ $dependent->title }}
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Comments Tab -->
            <div class="tab-pane fade" id="comments" role="tabpanel">
                <div class="card">
                    <div class="card-header">
                        <span class="panel-title">{{ _lang('Comments') }}</span>
                    </div>           
                    <div class="card-body">

                        @if($task->comments->count() > 0)
                        <!-- Comment List -->
                        <ul class="list-group mb-4">
                            @foreach($task->comments as $comment)
                            <li class="list-group-item">
                                <div class="d-flex justify-content-between">
                                    <strong>{{ $comment->user->name }}</strong>
                                    <small class="text-muted">{{ $comment->created_at->diffForHumans() }}</small>
                                </div>
                                <p class="mt-2">{{ $comment->content }}</p>
                            </li>
                            @endforeach
                        </ul>
                        @endif

                        <!-- Add Comment Form -->
                        <form class="validate" action="{{ route('tasks.add_comment', $task->id) }}" method="POST">
                            @csrf
                            <div class="form-group">
                                <textarea name="content" class="form-control" placeholder="{{ _lang('Add a comment') }}..." required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary btn-block">{{ _lang('Submit') }}</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Subtasks Tab -->
            <div class="tab-pane fade" id="subtasks" role="tabpanel">
                <div class="card">
                    <div class="card-header">
                        <span class="panel-title">{{ _lang('Sub Tasks') }}</span>
                    </div>           
                    <div class="card-body">
                        @if($task->subtasks->count() > 0)
                        <!-- Sub Tasks -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <ul class="list-group">
                                    @foreach($task->subtasks as $subtask)
                                    <li class="list-group-item d-flex justify-content-between align-items-center" data-subtask-id="{{ $subtask->id }}">
                                        <div>
                                            <strong class="text-primary">{{ $subtask->title }}</strong>
                                            <p>{!! xss_clean($subtask->description) !!}</p>
                                        </div>
                                        <div class="dropdown">
                                            <button class="btn {{ $buttonColors[$subtask->status] }} btn-xs dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false">
                                                {{ str_replace('_', ' ', $subtask->status) }}
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item update-subtask-status" href="#" data-status="To_Do"><i class="fas fa-hourglass-half text-danger"></i> {{ _lang('Mark as To Do') }}</a>
                                                <a class="dropdown-item update-subtask-status" href="#" data-status="In_Progress"><i class="far fa-check-circle text-primary"></i> {{ _lang('Mark as In Progress') }}</a>
                                                <a class="dropdown-item update-subtask-status" href="#" data-status="Completed"><i class="fas fa-check-circle text-success"></i> {{ _lang('Mark as Completed') }}</a>
                                            </div>
                                        </div>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        @endif

                        <form class="validate" action="{{ route('tasks.add_sub_task', $task->id) }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="control-label">{{ _lang('Title') }}</label>						
                                        <input type="text" class="form-control" name="title" value="{{ old('title') }}" required>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="control-label">{{ _lang('Description') }} <span class="required">*</span></label>						
                                        <textarea class="form-control mini-summernote" name="description">{{ old('description') }}</textarea>
                                    </div>
                                </div>

                                <div class="col-md-12 mt-2">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> {{ _lang('Submit') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Files Attachments Tab -->
            <div class="tab-pane fade" id="files" role="tabpanel">
                <div class="card">
                    <div class="card-header">
                        <span class="panel-title">{{ _lang('File Attachments') }}</span>
                    </div>
                    
                    <div class="card-body">
                        <ul class="list-group mb-4">
                            @foreach($task->files as $file)
                                <li class="list-group-item">
                                    <a href="{{ asset('storage/app/public/' . $file->file_path) }}" target="_blank"><i class="fas fa-paperclip"></i> {{ $file->file_name }}</a>
                                </li>
                            @endforeach
                        </ul>

                        <form class="validate" action="{{ route('tasks.upload_file', $task->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <input type="file" name="file" class="dropify" required>
                            </div>
                            <button type="submit" class="btn btn-primary">{{ _lang('Upload File') }}</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Assign Users Tab -->
            <div class="tab-pane fade" id="assign" role="tabpanel">

                <div class="card">
                    <div class="card-header">
                        <span class="panel-title">{{ _lang('Assign Users to Task') }}</span>
                    </div>
                    
                    <div class="card-body">
                        <form class="validate" action="{{ route('tasks.assign_users', $task->id) }}" method="POST">
                            @csrf
                            <div class="form-group">
                                <select name="user_ids[]" class="form-control select2" multiple required>
                                    @foreach($allUsers as $user)
                                        <option value="{{ $user->id }}" @if($task->users->contains($user)) selected @endif>
                                            {{ $user->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary mt-2">{{ _lang('Update Assigned Users') }}</button>
                        </form>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="task-log" role="tabpanel">
                <div class="card">
                    <div class="card-header">
                        <span class="panel-title">{{ _lang('Task Activity Log') }}</span>
                    </div>
                    
                    <div class="card-body">
                        @if($task->logs->count() == 0)
                            <p class="text-center">{{ _lang('No data found') }}</p>
                        @endif

                        @foreach($task->logs->reverse() as $log)
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <strong>{{ ucwords(str_replace('_',' ',$log->action)) }}</strong>: {{ $log->description }}
                                    @if($log->data)
                                        <ul>
                                            @foreach($log->data as $key => $value)
                                            <li>    
                                                @if(is_array($value) && !empty($value))
                                                    <strong>{{ ucwords(str_replace('_',' ',$key)) }}</strong>:
                                                    <em>{{ implode(', ', $value) }}</em>
                                                @elseif(!is_array($value))
                                                    <strong>{{ ucwords(str_replace('_',' ',$key)) }}</strong>:
                                                    <em>{{ strip_tags($value) }}</em>
                                                @endif        
                                            </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                                <div class="ml-3">
                                    <small class="text-primary text-nowrap"><i class="far fa-clock mr-1"></i>{{ $log->created_at->diffForHumans() }}</small><br>
                                    <small class="text-nowrap"><i class="fas fa-circle fs-10 mr-1 text-success"></i>{{ $log->user->name }}</small>
                                </div>
                            </li>
                        @endforeach
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection

@section('js-script')
<script>
(function ($) {
    "use strict";

    function getQueryParam(name) {
        var urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(name);
    }

    function updateQueryParam(tabName) {
        var newUrl = window.location.pathname + "?tab=" + tabName;
        history.replaceState(null, null, newUrl);
    }

    // Get tab name from query string
    var tabName = getQueryParam("tab");

    if (tabName) {
        var $tabLink = $('.nav-tabs a[href="#' + tabName + '"]');
        if ($tabLink.length) {
            $tabLink.tab("show");
        }
    } else {
        $('.nav-tabs a:first').tab("show");
    }

    // Update query string on tab click
    $(".nav-tabs [data-toggle='tab']").on("click", function (e) {
        e.preventDefault();
        $(this).tab("show");

        var tabId = $(this).attr("href").replace("#", "");
        updateQueryParam(tabId);
    });

    $('.update-task-status').on('click', function(e) {
        e.preventDefault();
        
        // Get the new status from the clicked link
        var newStatus = $(this).data('status');
        var taskId = $(this).data('task-id');
        
        // Get the dropdown button to update its text and style after success
        var $button = $(this).parent().prev();
        
        $.ajax({
            url: _tenant_url + `/tasks/${taskId}/update_status`,
            type: 'PUT',
            data: {
                status: newStatus,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                // Update the button text and class based on the new status.
                var buttonColors = {
                    'To_Do': 'btn-danger',
                    'In_Progress': 'btn-primary',
                    'Completed': 'btn-success'
                };
                $button.text(newStatus.replace('_', ' '));
                $button.removeClass('btn-danger btn-primary btn-success').addClass(buttonColors[newStatus]);
                $.toast({
                    text: response.success,
                    showHideTransition: 'slide',
                    icon: 'success',
                    position: 'top-right'
                });
            },
            error: function(xhr) {
                if(xhr.status == 422){
                    let json = JSON.parse(xhr.responseText);
                    $.toast({
                        text: json.error,
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right'
                    });
                }else{
                    alert('Failed to update subtask status.');
                }
            }
        });
    });

    $('.update-subtask-status').on('click', function(e) {
        e.preventDefault();
        
        // Get the new status from the clicked link
        var newStatus = $(this).data('status');
        
        // Find the parent <li> that holds the subtask ID
        var $li = $(this).closest('li');
        var subtaskId = $li.data('subtask-id');
        
        // Get the dropdown button to update its text and style after success
        var $button = $li.find('button.dropdown-toggle');
        
        $.ajax({
            url: _tenant_url + `/tasks/${subtaskId}/update_sub_task_status`,
            type: 'PUT',
            data: {
                status: newStatus,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                // Update the button text and class based on the new status.
                var buttonColors = {
                    'To_Do': 'btn-danger',
                    'In_Progress': 'btn-primary',
                    'Completed': 'btn-success'
                };
                $button.text(newStatus.replace('_', ' '));
                // Remove all possible color classes then add the new one
                $button.removeClass('btn-danger btn-primary btn-success').addClass(buttonColors[newStatus]);
                $.toast({
                    text: response.success,
                    showHideTransition: 'slide',
                    icon: 'success',
                    position: 'top-right'
                });
            },
            error: function(xhr) {
                alert('Failed to update subtask status.');
            }
        });
    });

})(jQuery);
</script>
@endsection
