@extends('layouts.app')

@section('content')
<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title">{{ _lang('Tasks Kanban View') }}</span>

                <div class="mt-sm-0 mt-2">
                    <a class="btn btn-dark btn-xs" href="{{ route('tasks.index') }}"><i class="fas fa-bars"></i> {{ _lang('List View') }}</a>
                    <a class="btn btn-primary btn-xs ml-auto" href="{{ route('tasks.create') }}"><i class="ti-plus"></i> {{ _lang('Create New Task') }}</a>
                </div>
			</div>
			<div class="card-body">
                <div id="kanban-view">
                    @foreach(['To_Do', 'In_Progress', 'Completed'] as $status)
					<ul class="kanban-col">
					    <li>
							<p class="kanban-title" style="background: {{ $taskColors[$status] }}">{{ str_replace('_',' ',$status) }}</p>
							<div class="cards">
								<ul id="{{ $status }}" class="status">			    
									@foreach($tasks[$status] ?? [] as $task)
									<li draggable="true" data-task-id="{{ $task->id }}">
										<div class="card">
											<div class="card-body">
                                                <p class="font-weight-bold">{{ Str::limit($task->title, 50) }}</p>

                                                <div class="d-flex align-items-center mt-2">
                                                    <p class="text-primary mr-1"><i class="far fa-calendar-alt fs-14"></i></p>
                                                    <p class="text-primary">{{ _lang('Due Date') }}</p>
                                                </div>
                                                <p><span class="badge badge-danger">{{ $task->due_date }}</span></p>

												<div class="mt-2">
													<a href="{{ route('tasks.show', $task->id) }}" target="_blank" class="btn btn-primary btn-xs"><i class="far fa-eye"></i></a>
													<a href="{{ route('tasks.edit', $task->id) }}" class="btn btn-warning btn-xs"><i class="fas fa-pencil-alt"></i></a>
												</div>	
											</div>	
										</div>
									</li>									
									@endforeach	
								</ul>								
							</div>
						</li>
					</ul>
                    @endforeach
                </div>
			</div>
		</div>
	</div>
</div>
@endsection

@section('js-script')
<script>
document.querySelectorAll('ul.status').forEach(ul => {
    ul.addEventListener('dragover', e => e.preventDefault());
    ul.addEventListener('drop', e => {
        e.preventDefault();
        const taskId = e.dataTransfer.getData('taskId');
        const newStatus = ul.id;
        const taskElement = document.querySelector(`[data-task-id='${taskId}']`);
        
        fetch(_tenant_url + `/tasks/${taskId}/update_status`, {
            method: 'PUT',
            headers: { 
                'X-CSRF-TOKEN': '{{ csrf_token() }}',   
                'Content-Type': 'application/json'  
            },
            body: JSON.stringify({ status: newStatus })
        }).then(response => {
            if (response.ok) {
                ul.appendChild(taskElement);
                return response.json().then(data => {
                    $.toast({
                        text: data.success,
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-right'
                    });
                });
            } else if (response.status === 422) {
                return response.json().then(data => {
                    $.toast({
                        text: data.error,
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right'
                    });
                });
            } else {
                console.error('Failed to update task status:', response);
            }
        }).catch(error => console.error('Error:', error));
    });
});

document.querySelectorAll('[draggable=true]').forEach(item => {
    item.addEventListener('dragstart', e => {
        e.dataTransfer.setData('taskId', item.dataset.taskId);
    });
});
</script>
@endsection
