@extends('layouts.app')

@section('content')
<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-sm-flex align-items-center justify-content-between">
				<span class="panel-title">{{ _lang('Tasks') }}</span>

				<div class="mt-sm-0 mt-2">
					<a class="btn btn-dark btn-xs" href="{{ route('tasks.kanban') }}"><i class="fas fa-stream"></i> {{ _lang('Kanban View') }}</a>
					<a class="btn btn-primary btn-xs" href="{{ route('tasks.create') }}"><i class="ti-plus"></i> {{ _lang('Create New Task') }}</a>
				</div>
			</div>
			<div class="card-body">
				<table id="tasks_table" class="table">
					<thead>
					    <tr>
                            <th>{{ _lang('Title') }}</th>
                            <th>{{ _lang('Assigned Users') }}</th>
                            <th>{{ _lang('Created') }}</th>
                            <th>{{ _lang('Due Date') }}</th>
                            <th class="text-center">{{ _lang('Status') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
@endsection

@section('js-script')
<script>
(function ($) {
	"use strict";

	$('#tasks_table').DataTable({
		processing: true,
		serverSide: true,
		ajax: _tenant_url + '/tasks/get_table_data',
		"columns" : [
			{ data : 'title', name : 'title' },
			{ data : 'users', name : 'users' },
            { data: 'user.name', name: 'user.name' },
            { data: 'due_date', name: 'due_date' },
            { data: 'status', name: 'status' },
			{ data : "action", name : "action" },
		],
		responsive: true,
		"bStateSave": true,
		"bAutoWidth":false,
		"ordering": false,
		"language": {
		   "decimal":        "",
		   "emptyTable":     "{{ _lang('No Data Found') }}",
		   "info":           "{{ _lang('Showing') }} _START_ {{ _lang('to') }} _END_ {{ _lang('of') }} _TOTAL_ {{ _lang('Entries') }}",
		   "infoEmpty":      "{{ _lang('Showing 0 To 0 Of 0 Entries') }}",
		   "infoFiltered":   "(filtered from _MAX_ total entries)",
		   "infoPostFix":    "",
		   "thousands":      ",",
		   "lengthMenu":     "{{ _lang('Show') }} _MENU_ {{ _lang('Entries') }}",
		   "loadingRecords": "{{ _lang('Loading...') }}",
		   "processing":     "{{ _lang('Processing...') }}",
		   "search":         "{{ _lang('Search') }}",
		   "zeroRecords":    "{{ _lang('No matching records found') }}",
		   "paginate": {
			  "first":      "{{ _lang('First') }}",
			  "last":       "{{ _lang('Last') }}",
			  "previous":   "<i class='fas fa-angle-left'></i>",
			  "next":       "<i class='fas fa-angle-right'></i>"
		  }
		}
	});
})(jQuery);
</script>
@endsection
