@extends('layouts.app')

@section('content')
<div class="row">
	<div class="{{ $alert_col }}">
		<div class="card">
			<div class="card-header">
				<span class="panel-title">{{ _lang('Create Task') }}</span>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="{{ route('tasks.store') }}" enctype="multipart/form-data">
                    @csrf
					<div class="row">
						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label">{{ _lang('Title') }}</label>						
								<input type="text" class="form-control" name="title" value="{{ old('title') }}" required>
							</div>
						</div>

                        <div class="col-md-12">
							<div class="form-group">
								<label class="control-label">{{ _lang('Due Date') }}</label>						
								<input type="text" class="form-control datepicker" name="due_date" value="{{ old('due_date') }}" required>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label">{{ _lang('Description') }} <span class="required">*</span></label>						
								<textarea class="form-control mini-summernote" name="description">{{ old('description') }}</textarea>
							</div>
						</div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label>{{ _lang('Custom Fields') }}</label>
                                <div id="customFieldsContainer">
                                    @if(old('custom_fields'))
                                        @foreach(old('custom_fields') as $index => $field)
                                            <div class="form-row custom-field-row mb-2">
                                                <div class="col">
                                                    <input type="text" name="custom_fields[{{ $index }}][key]" class="form-control" placeholder="Field Name" value="{{ $field['key'] ?? '' }}">
                                                </div>
                                                <div class="col">
                                                    <input type="text" name="custom_fields[{{ $index }}][value]" class="form-control" placeholder="Field Value" value="{{ $field['value'] ?? '' }}">
                                                </div>
                                                <div class="col-auto">
                                                    <button type="button" class="btn btn-danger remove-field"><i class="far fa-trash-alt"></i></button>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <button type="button" id="addCustomField" class="btn btn-outline-primary btn-xs mt-2"><i class="fas fa-plus-circle"></i> {{ _lang('Add Custom Field') }}</button>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="user_ids">{{ _lang('Assign Users') }}</label>
                                <select name="user_ids[]" id="user_ids" class="form-control select2" multiple>
                                    @foreach($allUsers as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="dependency_ids">{{ _lang('Task Dependencies') }} ({{ _lang('tasks that must be completed first') }}):</label>
                                <select name="dependency_ids[]" id="dependency_ids" class="form-control select2" multiple>
                                    @foreach($allTasks as $depTask)
                                        <option value="{{ $depTask->id }}">{{ $depTask->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
					
						<div class="col-md-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> {{ _lang('Submit') }}</button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
</div>
@endsection

@section('js-script')
<script>
(function ($) {
    "use strict";

    var fieldIndex = $('#customFieldsContainer .custom-field-row').length;
    
    $('#addCustomField').on('click', function(){
         var fieldRow = `<div class="form-row custom-field-row mb-2">
            <div class="col">
                <input type="text" name="custom_fields[`+fieldIndex+`][key]" class="form-control" placeholder="Field Name">
            </div>
            <div class="col">
                <input type="text" name="custom_fields[`+fieldIndex+`][value]" class="form-control" placeholder="Field Value">
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-danger remove-field"><i class="far fa-trash-alt"></i></button>
            </div>
         </div>`;
         $('#customFieldsContainer').append(fieldRow);
         fieldIndex++;
    });
    
    $(document).on('click', '.remove-field', function(){
         $(this).closest('.custom-field-row').remove();
    });
})(jQuery);
</script>
@endsection