@extends('layouts.app')

@section('content')
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
		    <div class="card-header">
				<span class="panel-title">{{ _lang('Package Details') }}</span>
			</div>
			
			<div class="card-body">
			    <table class="table table-bordered">
				    <tr><td>{{ _lang('Pasckage Name') }}</td><td>{{ $package->name }}</td></tr>
				    <tr><td>{{ _lang('Package Type') }}</td><td>{{ ucwords($package->package_type) }}</td></tr>
					<tr><td>{{ _lang('Cost') }}</td><td>{{ decimalPlace($package->cost, currency_symbol()) }}</td></tr>
					<tr><td>{{ _lang('Status') }}</td><td>{!! xss_clean(status($package->status)) !!}</td></tr>
					<tr>
						<td>{{ _lang('Is Popular') }}</td>
						<td>
							@if($package->is_popular == 1)
							{!! xss_clean(show_status(_lang('Yes'), 'success')) !!}
							@else
							{!! xss_clean(show_status(_lang('No'), 'danger')) !!}
							@endif
						</td>
					</tr>
					<tr><td>{{ _lang('Discount') }}</td><td>{{ $package->discount }} %</td></tr>
					<tr><td>{{ _lang('Trial Days') }}</td><td>{{ $package->trial_days }}</td></tr>
					<tr><td>{{ _lang('Role Based Users') }}</td><td>{{ $package->user_limit != '-1' ? $package->user_limit : _lang('Unlimited') }}</td></tr>
					<tr><td>{{ _lang('Employee Limit') }}</td><td>{{ $package->employee_limit != '-1' ? $package->employee_limit : _lang('Unlimited') }}</td></tr>
					<tr>
						<td>{{ _lang('Accounting') }}</td>
						<td>
							@if($package->accounting == 1)
							{!! xss_clean(show_status(_lang('Yes'), 'success')) !!}
							@else
							{!! xss_clean(show_status(_lang('No'), 'danger')) !!}
							@endif
						</td>
					</tr>
					<tr>
						<td>{{ _lang('Task Management') }}</td>
						<td>
							@if($package->task_management == 1)
							{!! xss_clean(show_status(_lang('Yes'), 'success')) !!}
							@else
							{!! xss_clean(show_status(_lang('No'), 'danger')) !!}
							@endif
						</td>
					</tr>
					<tr>
						<td>{{ _lang('Loan Management') }}</td>
						<td>
							@if($package->loan_management == 1)
							{!! xss_clean(show_status(_lang('Yes'), 'success')) !!}
							@else
							{!! xss_clean(show_status(_lang('No'), 'danger')) !!}
							@endif
						</td>
					</tr>
			    </table>
			</div>
	    </div>
	</div>
</div>
@endsection


