@extends('layouts.app')

@section('content')
<div class="row">
	<div class="{{ $alert_col }}">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title">{{ _lang('Update Journal entry') }}</span>
			</div>
			<div class="card-body">
                <form class="validate" action="{{ route('transactions.update', $transaction->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="form-group">
                                <label for="transaction_date" class="form-label">{{ _lang('Transaction Date') }}</label>
                                <input type="text" class="form-control datepicker" id="transaction_date" name="transaction_date" value="{{ old('transaction_date', $transaction->getRawOriginal('transaction_date')) }}" required>
                            </div>
                        </div>

                        <div class="col-lg-9">
                            <div class="form-group">
                                <label for="description" class="form-label">{{ _lang('Description') }}</label>
                                <input type="text" class="form-control" id="description" name="description" value="{{ old('description', $transaction->description) }}" required>
                            </div>
                        </div>
                    </div>

                    <table class="table table-bordered mt-4" id="entries-table">
                        <thead class="bg-light">
                            <tr>
                                <th class="text-dark pl-3">{{ _lang('Account') }}</th>
                                <th class="text-dark">{{ _lang('Type') }}</th>
                                <th class="text-dark">{{ _lang('Amount') }}</th>
                                <th class="text-dark text-center">{{ _lang('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($transaction->entries)
                                @foreach($transaction->entries as $index => $entry)
                                    <tr>
                                        <td class="pl-3">
                                            <select class="form-control select2" data-placeholder="{{ _lang('Select Account') }}" name="entries[{{ $index }}][account_id]" required>
                                                <option></option>
                                                @foreach($accounts as $accountType => $chartOfAccounts)
                                                    <optgroup label="{{ ucwords($accountType) }}">
                                                    @foreach($chartOfAccounts as $account)
                                                    <option value="{{ $account->id }}" {{ $entry->account_id == $account->id ? 'selected' : '' }}>{{ $account->account_id.' - '.$account->name }}</option>
                                                    @endforeach
                                                    </optgroup>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td>
                                            <select class="form-control entry-type" name="entries[{{ $index }}][type]" required>
                                                <option value="debit" {{ $entry->type == 'debit' ? 'selected' : '' }}>{{ _lang('Debit') }}</option>
                                                <option value="credit" {{ $entry->type == 'credit' ? 'selected' : '' }}>{{ _lang('Credit') }}</option>
                                            </select>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control float-field entry-amount @error('entries.'.$loop->index.'.amount') is-invalid @enderror" name="entries[{{ $index }}][amount]" value="{{ $entry->amount }}" required>
                                        </td>
                                        <td class="text-center">
                                            <button type="button" class="btn btn-danger btn-xs remove-entry"><i class="far fa-trash-alt mr-1"></i>{{ _lang('Remove') }}</button>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td class="pl-3">
                                        <select class="form-control select2" data-placeholder="{{ _lang('Select Account') }}" name="entries[0][account_id]" required>
                                            <option></option>
                                            @foreach($accounts as $accountType => $chartOfAccounts)
                                                <optgroup label="{{ ucwords($accountType) }}">
                                                @foreach($chartOfAccounts as $account)
                                                <option value="{{ $account->id }}">{{ $account->account_id.' - '.$account->name }}</option>
                                                @endforeach
                                                </optgroup>
                                            @endforeach
                                        </select>
                                    </td>
                                    <td>
                                        <select class="form-control entry-type" name="entries[0][type]" required>
                                            <option value="debit" selected>{{ _lang('Debit') }}</option>
                                            <option value="credit">{{ _lang('Credit') }}</option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control float-field entry-amount" name="entries[0][amount]" required>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-xs remove-entry"><i class="far fa-trash-alt mr-1"></i>{{ _lang('Remove') }}</button>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="pl-3">
                                        <select class="form-control select2" data-placeholder="{{ _lang('Select Account') }}" name="entries[1][account_id]" required>
                                            <option></option>
                                            @foreach($accounts as $accountType => $chartOfAccounts)
                                                <optgroup label="{{ ucwords($accountType) }}">
                                                @foreach($chartOfAccounts as $account)
                                                <option value="{{ $account->id }}">{{ $account->account_id.' - '.$account->name }}</option>
                                                @endforeach
                                                </optgroup>
                                            @endforeach
                                        </select>
                                    </td>
                                    <td>
                                        <select class="form-control entry-type" name="entries[1][type]" required>
                                            <option value="debit">{{ _lang('Debit') }}</option>
                                            <option value="credit" selected>{{ _lang('Credit') }}</option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control float-field entry-amount" name="entries[1][amount]" required>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-xs remove-entry"><i class="far fa-trash-alt mr-1"></i>{{ _lang('Remove') }}</button>
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>

                    <table class="table table-bordered bg-light">
                        <tr>
                            <td class=" border border-primary font-weight-bold w-50">
                                <span>{{ _lang('TOTAL DEBIT AMOUNT') }}:</span>
                                <span class="float-right" id="total-debit"></span>
                            </td>
                            <td class=" border border-primary font-weight-bold w-50">
                                <span>{{ _lang('TOTAL CREDIT AMOUNT') }}:</span>
                                <span class="float-right" id="total-credit"></span>
                            </td>                          
                        </tr>
                    </table>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="attachment" class="form-label">{{ _lang('Attachment') }}</label>
                                <input type="file" class="dropify" id="attachment" name="attachment" data-default-file="{{ $transaction->attachment != null ? asset('storage/app/public/'. $transaction->attachment) : '' }}">
                            </div>
                        </div>
                    </div>

                    <button type="button" id="add-entry" class="btn btn-secondary"><i class="fas fa-plus-circle mr-1"></i>{{ _lang('Add Another Entry') }}</button>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-check-circle mr-1"></i>{{ _lang('Submit Transaction') }}</button>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js-script')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        let entryIndex = {{ old('entries') ? count(old('entries')) : 2 }};

        document.getElementById('add-entry').addEventListener('click', function () {
            const tableBody = document.querySelector('#entries-table tbody');
            const newRow = document.createElement('tr');

            newRow.innerHTML = `
                <td class="pl-3">
                    <select class="form-control select2" data-placeholder="{{ _lang('Select Account') }}" name="entries[${entryIndex}][account_id]" required>
                        <option></option>
                        @foreach($accounts as $accountType => $chartOfAccounts)
                            <optgroup label="{{ ucwords($accountType) }}">
                            @foreach($chartOfAccounts as $account)
                            <option value="{{ $account->id }}">{{ $account->account_id.' - '.$account->name }}</option>
                            @endforeach
                            </optgroup>
                        @endforeach
                    </select>
                </td>
                <td>
                    <select class="form-control entry-type" name="entries[${entryIndex}][type]" required>
                        <option value="debit">{{ _lang('Debit') }}</option>
                        <option value="credit">{{ _lang('Credit') }}</option>
                    </select>
                </td>
                <td>
                    <input type="text" class="form-control float-field entry-amount" name="entries[${entryIndex}][amount]" required>
                </td>
                <td class="text-center">
                    <button type="button" class="btn btn-danger btn-xs remove-entry"><i class="far fa-trash-alt mr-1"></i>{{ _lang('Remove') }}</button>
                </td>
            `;
            tableBody.appendChild(newRow);
            entryIndex++;

            $(".select2").select2();

            updateTotals();
        });

        document.querySelector('#entries-table').addEventListener('click', function (e) {
            if (e.target && e.target.classList.contains('remove-entry')) {
                const row = e.target.closest('tr');
                row.remove();
            }
        });

        document.querySelector('#entries-table').addEventListener('input', function (e) {
            if (e.target && e.target.classList.contains('entry-amount')) {
                updateTotals();
            }
        });

        document.querySelector('#entries-table').addEventListener('change', function (e) {
            if (e.target && e.target.classList.contains('entry-type')) {
                updateTotals();
            }
        });

        document.querySelector('#entries-table').addEventListener('click', function (e) {
            if (e.target && e.target.classList.contains('remove-entry')) {
                e.target.closest('tr').remove();
                updateTotals();
            }
        });

        function updateTotals() {
            let totalDebit = 0;
            let totalCredit = 0;

            document.querySelectorAll('#entries-table tbody tr').forEach(row => {
                const type = row.querySelector('.entry-type').value;
                const amount = parseFloat(row.querySelector('.entry-amount').value) || 0;

                if (type === 'debit') {
                    totalDebit += amount;
                } else if (type === 'credit') {
                    totalCredit += amount;
                }
            });

            document.getElementById('total-debit').textContent = totalDebit.toFixed(2);
            document.getElementById('total-credit').textContent = totalCredit.toFixed(2);
        }

        updateTotals();
    });
</script>
@endsection