<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EmailTemplateSeeder extends Seeder {
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run() {
        $templates = [
            [
                "name"                => "Welcome Email",
                "slug"                => "WELCOME_EMAIL",
                "subject"             => "Welcome to Spike Office – Your All-in-One HR & Payroll Solution!",
                "email_body"          => "<div class='content'> <h1>Welcome to Spike Office, {{customerName}}!</h1> <p>We're thrilled to have you onboard. 🚀</p> <p>Spike Office is your all-in-one HRM & Payroll system designed to streamline your business operations. With our powerful tools, you can manage:</p> <ul style='text-align: left; padding: 0 40px;'> <li><b>HR & Employee Management</b> – Track employee records & attendance.</li> <li><b>Payroll Processing</b> – Automate salary & tax calculations.</li> <li><b>Employee Self-Service Portal</b> – Access payslips, leave requests & more.</li> <li><b>Accounting & Finance</b> – Manage expenses, invoices & reports.</li> <li><b>Loan Management</b> – Handle employee loans with ease.</li> <li><b>Task & Project Management</b> – Assign, track, and collaborate.</li> </ul> <a href='{{loginLink}}' class='btn'>Login to Spike Office</a> <p>Need help? Send us email at <a href='mailto:info@spikeoffice.com'>info@spikeoffice.com</a>.</p> <p>Let’s build a smarter workplace together!</p> </div>",
                "sms_body"            => "",
                "notification_body"   => "",
                "shortcode"           => "{{customerName}} {{loginLink}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 1,
                "template_type"       => 'admin',
            ],
            [
                "name"                => "Trial Period Ended",
                "slug"                => "TRIAL_PERIOD_ENDED",
                "subject"             => "Spike Office Trial Ended",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>Spike Office Trial Ended</h2> <p>Dear {{customerName}},</p> <p>We hope this email finds you well. We wanted to remind you that your trial period has ended as of {{trialEndDate}}.</p> <p>We hope you found our service useful during the trial period. If you would like to continue using our service, please pay for subscription.</p> <p>If you have any questions or concerns, please do not hesitate to contact us. We are always here to help.</p> <p>Thank you for your interest in our service. We hope to continue serving you in the future.</p> </div>",
                "sms_body"            => "",
                "notification_body"   => "",
                "shortcode"           => "{{customerName}} {{trialEndDate}} {{planName}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 1,
                "template_type"       => 'admin',
            ],
            [
                "name"                => "Subscription Reminder",
                "slug"                => "SUBSCRIPTION_REMINDER",
                "subject"             => "Subscription Reminder",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>Spike Office Renewal Reminder </h2> <p>Dear {{customerName}},</p> <p>We hope this email finds you well. We wanted to remind you that your subscription is expiring on {{expiryDate}}.</p> <p>If you want to continue using our service, please renew your subscription by visiting our website and selecting a subscription plan that suits your needs.</p> <p>If you have already renewed your subscription, please disregard this email. Otherwise, please renew your subscription before the expiry date to avoid any interruption in your service.</p> <p>If you have any questions or concerns, please do not hesitate to contact us. We are always here to help.</p> <p>Thank you for choosing our service. We appreciate your business and look forward to continuing to serve you.</p> </div>",
                "sms_body"            => "",
                "notification_body"   => "",
                "shortcode"           => "{{customerName}} {{expiryDate}} {{planName}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 1,
                "template_type"       => 'admin',
            ],
            [
                "name"                => "Subscription Payment Confirmation",
                "slug"                => "SUBSCRIPTION_PAYMENT_CONFIRMATION",
                "subject"             => "Subscription Payment Confirmation",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>Spike Office Payment Confirmation</h2> <p>Dear {{customerName}},</p> <p>Thank you for renewing your subscription to (Package Name: {{packageName}}). Your payment has been received and your subscription has been renewed until {{expiryDate}}.</p> <p>You can now continue using our service without any interruption. If you have any questions or concerns, please do not hesitate to contact us. We are always here to help.</p> <p>Thank you for choosing our service. We appreciate your business and look forward to continuing to serve you.</p> </div>",
                "sms_body"            => "",
                "notification_body"   => "",
                "shortcode"           => "{{customerName}} {{expiryDate}} {{planName}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 1,
                "template_type"       => 'admin',
            ],
            [
                "name"                => "New Message",
                "slug"                => "NEW_MESSAGE",
                "subject"             => "You Have a New Message",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'><p>Hi {{recipientName}},</p> <p>I hope this email finds you well.</p> <p>This is to inform you that you have received a new message. <p>Please login to your account to view the full message.</p></div>",
                "sms_body"            => "You have received a new message. Please login to your account to see the message.",
                "notification_body"   => "<p>Hi {{recipientName}},</p><p>You have received a new message.</p><p><a class='btn btn-primary btn-xs mt-2' href='{{messageLink}}'>View Message</a></p>",
                "shortcode"           => "{{recipientName}} {{loginUrl}} {{messageLink}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "New Leave Application Submitted",
                "slug"                => "NEW_LEAVE_APPLICATION",
                "subject"             => "New Leave Application Submitted",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>New Leave Application Submitted</h2> <p>I am writing to let you know that a new leave application has been submitted by an employee.</p> <p><a href='{{applicationLink}}'>View Application</a></p></div>",
                "sms_body"            => "New Leave Application Submitted",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>New Leave Application Submitted</h5> <p>I am writing to let you know that a new leave application has been submitted by an employee.</p> <p><a class='btn btn-primary btn-xs mt-2' href='{{applicationLink}}'>View Application</a></p>",
                "shortcode"           => "{{applicationLink}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "Leave Application Approved",
                "slug"                => "LEAVE_APPLICATION_APPROVED",
                "subject"             => "Leave Application Approved",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>Leave Application Approved</h2> <p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that your leave application has been approved.</p></div>",
                "sms_body"            => "Your Leave Application has been approved",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>Leave Application Approved</h5> <p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that your leave application has been approved.</p>",
                "shortcode"           => "{{employeeName}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "Leave Application Rejected",
                "slug"                => "LEAVE_APPLICATION_REJECTED",
                "subject"             => "Leave Application Rejected",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>Leave Application Rejected</h2> <p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that your leave application has been rejected. You can contact with the authority for more details.</p></div>",
                "sms_body"            => "Your Leave Application has been rejected",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>Leave Application Rejected</h5> <p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that your leave application has been rejected. You can contact with the authority for more details.</p>",
                "shortcode"           => "{{employeeName}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "New Loan Application Submitted",
                "slug"                => "NEW_LOAN_APPLICATION",
                "subject"             => "New Loan Application Submitted",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>New Loan Application Submitted</h2> <p>I am writing to let you know that a new loan application has been submitted by an employee.</p> <p><a href='{{applicationLink}}'>View Application</a></p></div>",
                "sms_body"            => "New Loan Application Submitted",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>New Loan Application Submitted</h5> <p>I am writing to let you know that a new loan application has been submitted by an employee.</p> <p><a href='{{applicationLink}}' class='btn btn-primary btn-xs mt-2'>View Application</a></p>",
                "shortcode"           => "{{applicationLink}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "Loan Application Approved",
                "slug"                => "LOAN_APPLICATION_APPROVED",
                "subject"             => "Loan Application Approved",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>Loan Application Approved</h2> <p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that your Loan application has been approved.</p></div>",
                "sms_body"            => "Your Loan Application has been approved",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>Loan Application Approved</h5> <p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that your Loan application has been approved.</p>",
                "shortcode"           => "{{employeeName}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "Loan Application Rejected",
                "slug"                => "LEAVE_APPLICATION_REJECTED",
                "subject"             => "Loan Application Rejected",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>Loan Application Rejected</h2> <p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that your Loan application has been rejected. You can contact with the authority for more details.</p></div>",
                "sms_body"            => "Your Leave Application has been rejected",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>Loan Application Rejected</h5> <p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that your Loan application has been rejected. You can contact with the authority for more details.</p>",
                "shortcode"           => "{{employeeName}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "Payslip Notification",
                "slug"                => "PAYSLIP_NOTIFICATION",
                "subject"             => "Access Your Payslip for {{monthYear}}",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>Your payslip for the period of {{monthYear}} is now available.</h2></div>",
                "sms_body"            => "Your payslip for the period of {{monthYear}} is now available.",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>Your payslip for the period of {{monthYear}} is now available.</h5>",
                "shortcode"           => "{{monthYear}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "Task Assigned",
                "slug"                => "TASK_ASSIGNED",
                "subject"             => "You have been assigned to a new task",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>You have been assigned to a new task</h2> <p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that you have been assigned to task: {{title}}.</p></div>",
                "sms_body"            => "You have been assigned to a new task: {{title}}",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>You have been assigned to a new task</h5><p>Dear {{employeeName}},</p> <p>We hope this email finds you well. We wanted to inform you that you have been assigned to task: {{title}}.</p>",
                "shortcode"           => "{{employeeName}} {{title}} {{dueDate}} {{taskUrl}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "Task Commented",
                "slug"                => "TASK_COMMENTED",
                "subject"             => "A new comment posted on your task",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>A new comment posted on your task</h2> <p>{{commenter}} commented on task: {{title}}</p></div>",
                "sms_body"            => "{{commenter}} commented on task: {{title}}",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>A new comment posted on your task</h5><p>{{commenter}} commented on task: {{title}}</p>",
                "shortcode"           => "{{commenter}} {{title}} {{dueDate}} {{taskUrl}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 0,
                "template_type"       => 'tenant',
            ],
            [
                "name"                => "Task Status Updated",
                "slug"                => "TASK_STATUS_UPDATED",
                "subject"             => "Task status has been updated",
                "email_body"          => "<div style='font-family: Arial, sans-serif; font-size: 14px;'> <h2 style='color: #333333;'>Task status has been updated</h2> <p>The task '{{title}}' status has been updated to {{status}}</p></div>",
                "sms_body"            => "The task '{{title}}' status has been updated to {{status}}",
                "notification_body"   => "<h5 style='color: #333333; margin-bottom: 10px;'>Task status has been updated</h5><p>The task '{{title}}' status has been updated to {{status}}</p>",
                "shortcode"           => "{{title}} {{status}} {{dueDate}} {{taskUrl}}",
                "email_status"        => 0,
                "sms_status"          => 0,
                "notification_status" => 0,
                "template_mode"       => 3,
                "template_type"       => 'tenant',
            ],
        ];

        foreach ($templates as $template) {
            $existingTemplate = DB::table('email_templates')
                ->where('slug', $template['slug'])
                ->first();

            if ($existingTemplate) {
                DB::table('email_templates')
                    ->where('slug', $template['slug'])
                    ->update(['shortcode' => $template['shortcode']]);
            } else {
                DB::table('email_templates')->insert($template);
            }
        }
    }
}
