<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email');
            $table->string('user_type', 20)->comment('superadmin | admin | user | employee');
            $table->unsignedBigInteger('tenant_id')->nullable();
            $table->tinyInteger('tenant_owner')->nullable();
            $table->bigInteger('role_id')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->string('profile_picture')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->string('phone', 30)->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip', 30)->nullable();
            $table->text('address')->nullable();
            $table->string('provider')->nullable();    // Social Login
            $table->string('provider_id')->nullable(); // Social Login
            $table->text('custom_fields')->nullable();
            $table->rememberToken();
            $table->timestamps();

            $table->string('email_tenant')->virtualAs(
                "CONCAT(email, '-', COALESCE(tenant_id, 0))"
            );

            $table->unique('email_tenant');
            $table->foreign('tenant_id')->references('id')->on('tenants')->cascadeOnDelete();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('users');
    }
}
