<?php
namespace App\Policies;

use App\Models\Task;
use App\Models\User;

class TaskPolicy {
    /**
     * Determine whether the user can update the task.
     * Allow if the user is the owner or an assigned user.
     */
    public function update(User $user, Task $task) {
        return $user->id === $task->user_id;
    }

    /**
     * Determine whether the user can delete the task.
     * Allow deletion only for the owner.
     */
    public function delete(User $user, Task $task) {
        return $user->id === $task->user_id;
    }

    /**
     * Determine whether the user can update the status of the task.
     * Allow if the user is the owner or an assigned user.
     */
    public function updateStatus(User $user, Task $task) {
        return $user->id === $task->user_id || $task->users()->where('users.id', $user->id)->exists();
    }

    /**
     * Determine whether the user can update the status of the sub task.
     * Allow if the user is the owner or an assigned user.
     */
    public function updateSubTaskStatus(User $user, Task $task) {
        return $user->id === $task->user_id || $task->users()->where('users.id', $user->id)->exists();
    }

}
